/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import org.jboss.modules.AbstractDependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.PathFilter;
import org.jboss.modules.PathFilters;

public final class ModuleDependencySpec
extends AbstractDependencySpec {
    private final ModuleIdentifier moduleIdentifier;
    private final boolean optional;

    private ModuleDependencySpec(ModuleIdentifier moduleIdentifier, boolean optional, PathFilter importFilter, PathFilter exportFilter) {
        super(importFilter, exportFilter);
        this.moduleIdentifier = moduleIdentifier;
        this.optional = optional;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public static Builder build(final ModuleIdentifier moduleIdentifier) {
        return new Builder(){
            private boolean optional = false;
            private PathFilter importFilter = PathFilters.acceptAll();
            private PathFilter exportFilter = PathFilters.rejectAll();

            public Builder setOptional(boolean optional) {
                this.optional = optional;
                return this;
            }

            public Builder setImportFilter(PathFilter importFilter) {
                this.importFilter = importFilter;
                return this;
            }

            public Builder setExportFilter(PathFilter exportFilter) {
                this.exportFilter = exportFilter;
                return this;
            }

            public ModuleDependencySpec create() {
                return new ModuleDependencySpec(moduleIdentifier, this.optional, this.importFilter, this.exportFilter);
            }
        };
    }

    public static interface Builder {
        public Builder setImportFilter(PathFilter var1);

        public Builder setExportFilter(PathFilter var1);

        public Builder setOptional(boolean var1);

        public ModuleDependencySpec create();
    }
}

