/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import org.jboss.modules.Module;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.UnlockedReadHashMap;
import sun.misc.Unsafe;

public abstract class ConcurrentClassLoader
extends SecureClassLoader {
    private static final boolean LOCKLESS;
    protected static final Enumeration<URL> EMPTY_ENUMERATION;
    final ConcurrentMap<Object, Object> localStorage = new UnlockedReadHashMap<Object, Object>();

    protected ConcurrentClassLoader(ConcurrentClassLoader parent) {
        super(parent);
    }

    protected ConcurrentClassLoader() {
    }

    @Override
    public final Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, false, false);
    }

    @Override
    public final Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, false, resolve);
    }

    public final Class<?> loadExportedClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, true, false);
    }

    public final Class<?> loadExportedClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, true, resolve);
    }

    protected Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        throw new ClassNotFoundException(className);
    }

    @Override
    protected final Class<?> findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, false, false);
    }

    @Override
    public final URL getResource(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return super.getResource(name);
        }
        return this.findResource(name, false);
    }

    @Override
    public final Enumeration<URL> getResources(String name) throws IOException {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return super.getResources(name);
        }
        return this.findResources(name, false);
    }

    protected URL findResource(String name, boolean exportsOnly) {
        return null;
    }

    @Override
    protected final URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return EMPTY_ENUMERATION;
    }

    @Override
    protected final Enumeration<URL> findResources(String name) {
        return EMPTY_ENUMERATION;
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        URL url = this.findResource(name, exportsOnly);
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return super.getResourceAsStream(name);
        }
        return this.findResourceAsStream(name, false);
    }

    private Class<?> performLoadClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("name is null");
        }
        for (String s : Module.systemPackages) {
            if (!className.startsWith(s)) continue;
            return this.findSystemClass(className);
        }
        return this.performLoadClassChecked(className, exportsOnly, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> performLoadClassChecked(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (Thread.holdsLock(this)) {
            if (LOCKLESS) {
                Unsafe unsafe = UnsafeHolder.UNSAFE;
                unsafe.monitorExit(this);
                try {
                    Class<?> clazz = this.performLoadClassChecked(className, exportsOnly, resolve);
                    return clazz;
                }
                finally {
                    unsafe.monitorEnter(this);
                }
            }
            if (Thread.currentThread() != LoaderThreadHolder.LOADER_THREAD) {
                Queue<LoadRequest> queue;
                LoadRequest req = new LoadRequest(className, resolve, exportsOnly, this, AccessController.getContext());
                Queue<LoadRequest> queue2 = queue = LoaderThreadHolder.REQUEST_QUEUE;
                synchronized (queue2) {
                    queue.add(req);
                    queue.notify();
                }
                boolean intr = false;
                try {
                    while (!req.done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
                return req.result;
            }
        }
        return this.findClass(className, exportsOnly, resolve);
    }

    static {
        Package.getPackages();
        String locklessDefault = "false";
        try {
            Class.forName("sun.misc.Unsafe", false, null);
            locklessDefault = "true";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOCKLESS = Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.lockless", locklessDefault)));
        EMPTY_ENUMERATION = Collections.enumeration(Collections.emptySet());
    }

    private static final class UnsafeHolder {
        static Unsafe UNSAFE;

        private UnsafeHolder() {
        }

        static {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                UNSAFE = (Unsafe)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    }

    static class LoaderThread
    extends Thread {
        LoaderThread() {
        }

        @Override
        public void interrupt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Queue<LoadRequest> queue = LoaderThreadHolder.REQUEST_QUEUE;
            while (true) {
                try {
                    while (true) {
                        LoadRequest request;
                        Queue<LoadRequest> queue2 = queue;
                        synchronized (queue2) {
                            while ((request = queue.poll()) == null) {
                                queue.wait();
                            }
                        }
                        final ConcurrentClassLoader loader = request.requester;
                        Class result = null;
                        ConcurrentClassLoader concurrentClassLoader = loader;
                        synchronized (concurrentClassLoader) {
                            try {
                                SecurityManager sm = System.getSecurityManager();
                                if (sm != null) {
                                    final LoadRequest localRequest = request;
                                    result = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                                        @Override
                                        public Class<?> run() throws ClassNotFoundException {
                                            return loader.performLoadClassChecked(localRequest.className, localRequest.exportsOnly, localRequest.resolve);
                                        }
                                    }, request.context);
                                } else {
                                    result = loader.performLoadClassChecked(request.className, request.exportsOnly, request.resolve);
                                }
                            }
                            finally {
                                request.result = result;
                                request.done = true;
                                loader.notifyAll();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    static class LoadRequest {
        private final String className;
        private final boolean resolve;
        private final ConcurrentClassLoader requester;
        private final AccessControlContext context;
        Class<?> result;
        private boolean exportsOnly;
        boolean done;

        LoadRequest(String className, boolean resolve, boolean exportsOnly, ConcurrentClassLoader requester, AccessControlContext context) {
            this.className = className;
            this.resolve = resolve;
            this.exportsOnly = exportsOnly;
            this.requester = requester;
            this.context = context;
        }
    }

    static final class LoaderThreadHolder {
        static final Thread LOADER_THREAD;
        static final Queue<LoadRequest> REQUEST_QUEUE;

        private LoaderThreadHolder() {
        }

        static {
            REQUEST_QUEUE = new ArrayDeque<LoadRequest>();
            LoaderThread thr = new LoaderThread();
            thr.setName("ClassLoader Thread");
            thr.setDaemon(true);
            thr.start();
            LOADER_THREAD = thr;
        }
    }
}

