/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.modules.CallerContext;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.IdentityHashSet;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModularContentHandlerFactory;
import org.jboss.modules.ModularURLStreamHandlerFactory;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Paths;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.Resource;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.SystemClassPathModuleLoader;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.NoopModuleLogger;

public final class Module {
    private static final AtomicReference<ModuleLoader> BOOT_MODULE_LOADER = new AtomicReference();
    static final String[] systemPackages;
    static final String[] systemPaths;
    static volatile ModuleLogger log;
    private final ModuleIdentifier identifier;
    private final String mainClassName;
    private final ModuleClassLoader moduleClassLoader;
    private final ModuleLoader moduleLoader;
    private final Object myKey;
    private final LocalLoader fallbackLoader;
    private volatile Paths<LocalLoader, Dependency> paths = Paths.none();
    private static final Dependency[] NO_DEPENDENCIES;
    private static final RuntimePermission GET_CLASS_LOADER;
    private static final RuntimePermission GET_SYSTEM_MODULE;
    private static final RuntimePermission GET_BOOT_MODULE_LOADER;
    private static final RuntimePermission ACCESS_MODULE_LOGGER;
    private static final AtomicReferenceFieldUpdater<Module, Paths<LocalLoader, Dependency>> pathsUpdater;

    private static <A, B> AtomicReferenceFieldUpdater<A, B> unsafeCast(AtomicReferenceFieldUpdater<?, ?> updater) {
        return updater;
    }

    Module(ModuleSpec spec, ModuleLoader moduleLoader, Object myKey) {
        this.moduleLoader = moduleLoader;
        this.myKey = myKey;
        this.identifier = spec.getModuleIdentifier();
        this.mainClassName = spec.getMainClass();
        this.fallbackLoader = spec.getFallbackLoader();
        ModuleClassLoader.Configuration configuration = new ModuleClassLoader.Configuration(this, spec.getAssertionSetting(), spec.getResourceLoaders());
        ModuleClassLoaderFactory factory = spec.getModuleClassLoaderFactory();
        ModuleClassLoader moduleClassLoader = null;
        if (factory != null) {
            moduleClassLoader = factory.create(configuration);
        }
        if (moduleClassLoader == null) {
            moduleClassLoader = new ModuleClassLoader(configuration);
        }
        this.moduleClassLoader = moduleClassLoader;
    }

    LocalLoader getFallbackLoader() {
        return this.fallbackLoader;
    }

    Dependency[] getDependencies() {
        return this.paths.getSourceList((Dependency[])NO_DEPENDENCIES);
    }

    ModuleClassLoader getClassLoaderPrivate() {
        return this.moduleClassLoader;
    }

    public static Module getSystemModule() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_SYSTEM_MODULE);
        }
        return SystemModuleHolder.SYSTEM;
    }

    public Resource getExportedResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath);
    }

    public void run(String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        try {
            if (this.mainClassName == null) {
                throw new NoSuchMethodException("No main class defined for " + this);
            }
            Class<?> mainClass = this.moduleClassLoader.loadClass(this.mainClassName);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new NoSuchMethodException("Main method is not static for " + this);
            }
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public <S> ServiceLoader<S> loadService(Class<S> serviceType) {
        return ServiceLoader.load(serviceType, this.moduleClassLoader);
    }

    public static <S> ServiceLoader<S> loadServiceFromCallerModuleLoader(ModuleIdentifier identifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.getCallerModuleLoader().loadModule(identifier).loadService(serviceType);
    }

    @Deprecated
    public static <S> ServiceLoader<S> loadServiceFromCurrent(ModuleIdentifier identifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.getCallerModuleLoader().loadModule(identifier).loadService(serviceType);
    }

    public ModuleClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASS_LOADER);
        }
        return this.moduleClassLoader;
    }

    public Set<String> getExportedPaths() {
        return Collections.unmodifiableSet(this.getPaths(true).keySet());
    }

    public static Module forClass(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        return Module.forClassLoader(cl, false);
    }

    public static Module forClassLoader(ClassLoader cl, boolean search) {
        if (cl instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)cl).getModule();
        }
        if (cl == null || cl == ClassLoader.getSystemClassLoader()) {
            return Module.getSystemModule();
        }
        if (search) {
            return Module.forClassLoader(cl.getParent(), true);
        }
        return null;
    }

    public static ModuleLoader getBootModuleLoader() {
        ModuleLoader loader;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_BOOT_MODULE_LOADER);
        }
        while ((loader = BOOT_MODULE_LOADER.get()) == null && !BOOT_MODULE_LOADER.compareAndSet(null, loader = DefaultBootModuleLoaderHolder.INSTANCE)) {
        }
        return loader;
    }

    @Deprecated
    public static ModuleLoader getSystemModuleLoader() {
        return Module.getBootModuleLoader();
    }

    static void initBootModuleLoader(ModuleLoader loader) {
        BOOT_MODULE_LOADER.set(loader);
    }

    public static ModuleLoader getCallerModuleLoader() {
        return Module.getCallerModule().getModuleLoader();
    }

    @Deprecated
    public static ModuleLoader getCurrentModuleLoader() {
        return Module.getCallerModuleLoader();
    }

    public static ModuleLoader getContextModuleLoader() {
        return Module.forClassLoader(Thread.currentThread().getContextClassLoader(), true).getModuleLoader();
    }

    public static Module getModuleFromCallerModuleLoader(ModuleIdentifier identifier) throws ModuleLoadException {
        return Module.getCallerModuleLoader().loadModule(identifier);
    }

    @Deprecated
    public static Module getModuleFromCurrentLoader(ModuleIdentifier identifier) throws ModuleLoadException {
        return Module.getModuleFromCallerModuleLoader(identifier);
    }

    public static Module getCallerModule() {
        return Module.forClass(CallerContext.getCallingClass());
    }

    @Deprecated
    public static Module getCurrentModule() {
        return Module.getCallerModule();
    }

    public Module getModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return this.moduleLoader.loadModule(identifier);
    }

    public static Class<?> loadClassFromBootModuleLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getBootModuleLoader().loadModule(moduleIdentifier).getClassLoader());
    }

    @Deprecated
    public static Class<?> loadClassFromSystemLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Module.loadClassFromBootModuleLoader(moduleIdentifier, className);
    }

    public static Class<?> loadClassFromCallerModuleLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getModuleFromCallerModuleLoader(moduleIdentifier).getClassLoader());
    }

    @Deprecated
    public static Class<?> loadClassFromCurrentLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getModuleFromCallerModuleLoader(moduleIdentifier).getClassLoader());
    }

    Class<?> loadModuleClass(String className, boolean exportsOnly, boolean resolve) {
        LocalLoader fallbackLoader;
        for (String s : systemPackages) {
            if (!className.startsWith(s)) continue;
            try {
                return this.moduleClassLoader.loadClass(className, resolve);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        String path = Module.pathOfClass(className);
        Map<String, List<LocalLoader>> paths = this.getPaths(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                Class<?> clazz = loader.loadClassLocal(className, resolve);
                if (clazz == null) continue;
                return clazz;
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            return fallbackLoader.loadClassLocal(className, resolve);
        }
        return null;
    }

    URL getResource(String name, boolean exportsOnly) {
        List<Resource> resourceList;
        Iterator<Resource> i$;
        LocalLoader fallbackLoader;
        for (String s : systemPaths) {
            if (!name.startsWith(s)) continue;
            return this.moduleClassLoader.getResource(name);
        }
        log.trace("Attempting to find resource %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map<String, List<LocalLoader>> paths = this.getPaths(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList2 = loader.loadResourceLocal(name);
                Iterator<Resource> i$2 = resourceList2.iterator();
                if (!i$2.hasNext()) continue;
                Resource resource = i$2.next();
                return resource.getURL();
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null && (i$ = (resourceList = fallbackLoader.loadResourceLocal(name)).iterator()).hasNext()) {
            Resource resource = i$.next();
            return resource.getURL();
        }
        return null;
    }

    Enumeration<URL> getResources(String name, boolean exportsOnly) {
        LocalLoader fallbackLoader;
        for (String s : systemPaths) {
            if (!name.startsWith(s)) continue;
            try {
                return this.moduleClassLoader.getResources(name);
            }
            catch (IOException e) {
                return ConcurrentClassLoader.EMPTY_ENUMERATION;
            }
        }
        log.trace("Attempting to find all resources %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map<String, List<LocalLoader>> paths = this.getPaths(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        ArrayList<URL> list = new ArrayList<URL>();
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList = loader.loadResourceLocal(name);
                for (Resource resource : resourceList) {
                    list.add(resource.getURL());
                }
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            List<Resource> resourceList = fallbackLoader.loadResourceLocal(name);
            for (Resource resource : resourceList) {
                list.add(resource.getURL());
            }
        }
        return list.size() == 0 ? ConcurrentClassLoader.EMPTY_ENUMERATION : Collections.enumeration(list);
    }

    public URL getExportedResource(String name) {
        return this.getResource(name, true);
    }

    public Enumeration<URL> getExportedResources(String name) {
        return this.getResources(name, true);
    }

    static String pathOfClass(String className) {
        String resourceName = className.replace('.', '/');
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String pathOf(String resourceName) {
        if (resourceName.indexOf(47) == 0) {
            return Module.pathOf(resourceName.substring(1));
        }
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String fileNameOfClass(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String toString() {
        return "Module \"" + this.identifier + "\"" + " from " + this.moduleLoader.toString();
    }

    public static ModuleLogger getModuleLogger() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
        }
        return log;
    }

    public static void setModuleLogger(ModuleLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
        }
        logger.greeting();
        log = logger;
    }

    public static long getStartTime() {
        return StartTimeHolder.START_TIME;
    }

    Paths<LocalLoader, Dependency> linkExports(Paths<LocalLoader, Dependency> paths) throws ModuleLoadException {
        return this.linkExports(paths, new FastCopyHashSet<Module>());
    }

    Paths<LocalLoader, Dependency> linkExports(Paths<LocalLoader, Dependency> paths, Set<Module> visited) throws ModuleLoadException {
        return this.linkExports(paths, paths.getSourceList((Dependency[])NO_DEPENDENCIES), visited);
    }

    Paths<LocalLoader, Dependency> linkExports(Paths<LocalLoader, Dependency> paths, Dependency[] dependencies, Set<Module> visited) throws ModuleLoadException {
        if (!visited.add(this)) {
            throw new ModuleLoadException("Circular export path in " + this.identifier);
        }
        HashMap newMap = new HashMap();
        for (Dependency dependency : dependencies) {
            PathFilter exportFilter = dependency.getExportFilter();
            PathFilter importFilter = dependency.getImportFilter();
            if (importFilter == PathFilters.rejectAll() || exportFilter == PathFilters.rejectAll()) continue;
            if (dependency instanceof LocalDependency) {
                LocalDependency localDependency = (LocalDependency)dependency;
                LocalLoader localLoader = localDependency.getLocalLoader();
                for (String path : localDependency.getPaths()) {
                    if (!importFilter.accept(path) || !exportFilter.accept(path)) continue;
                    Module.addToMapList(newMap, path, localLoader);
                }
                continue;
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                ModuleIdentifier id = moduleDependency.getIdentifier();
                Module module = moduleLoader.loadModule(id, visited);
                Map<String, List<LocalLoader>> pathsMap = module.getPaths(true);
                for (String path : pathsMap.keySet()) {
                    if (!importFilter.accept(path) || !exportFilter.accept(path)) continue;
                    Module.addToMapList(newMap, path, pathsMap.get(path));
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid dependency " + dependency + " encountered");
        }
        Module.removeDuplicatesFromLists(newMap.values());
        Paths<LocalLoader, Dependency> newPaths = new Paths<LocalLoader, Dependency>(dependencies, null, newMap);
        pathsUpdater.compareAndSet(this, paths, newPaths);
        visited.remove(this);
        return newPaths;
    }

    private void linkImports(Paths<LocalLoader, Dependency> paths) throws ModuleLoadException {
        Dependency[] dependencies;
        FastCopyHashSet<Module> visited = new FastCopyHashSet<Module>();
        visited.add(this);
        HashMap newMap = new HashMap();
        for (Dependency dependency : dependencies = paths.getSourceList((Dependency[])NO_DEPENDENCIES)) {
            PathFilter importFilter = dependency.getImportFilter();
            if (importFilter == PathFilters.rejectAll()) continue;
            if (dependency instanceof LocalDependency) {
                LocalDependency localDependency = (LocalDependency)dependency;
                LocalLoader localLoader = localDependency.getLocalLoader();
                for (String path : localDependency.getPaths()) {
                    if (!importFilter.accept(path)) continue;
                    Module.addToMapList(newMap, path, localLoader);
                }
                continue;
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                ModuleIdentifier id = moduleDependency.getIdentifier();
                Module module = moduleLoader.loadModule(id, visited);
                Map<String, List<LocalLoader>> pathsMap = module.getPaths(true);
                for (String path : pathsMap.keySet()) {
                    if (!importFilter.accept(path)) continue;
                    Module.addToMapList(newMap, path, pathsMap.get(path));
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid dependency " + dependency + " encountered");
        }
        Module.removeDuplicatesFromLists(newMap.values());
        Paths newPaths = new Paths(dependencies, newMap, paths.getExportedPaths());
        pathsUpdater.compareAndSet(this, paths, newPaths);
    }

    Map<String, List<LocalLoader>> getPaths(boolean exportsOnly) {
        Paths<LocalLoader, Dependency> paths = this.paths;
        Map<String, List<LocalLoader>> map = paths.getPaths(exportsOnly);
        if (map != null) {
            return map;
        }
        if (exportsOnly) {
            try {
                this.linkExports(paths);
            }
            catch (ModuleLoadException e) {
                log.trace((Throwable)e, "Failed to link exports for %s", (Object)this);
                throw e.toError();
            }
        }
        try {
            this.linkImports(paths);
        }
        catch (ModuleLoadException e) {
            log.trace((Throwable)e, "Failed to link imports for %s", (Object)this);
            throw e.toError();
        }
        return this.getPaths(exportsOnly);
    }

    private static <K, V> void addToMapList(Map<K, List<V>> map, K key, V item) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(item);
    }

    private static <K, V> void addToMapList(Map<K, List<V>> map, K key, List<V> items) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.addAll(items);
    }

    private static <E> void removeDuplicatesFromLists(Collection<List<E>> lists) {
        IdentityHashSet<E> set = new IdentityHashSet<E>(128);
        for (List<E> list : lists) {
            if (list.size() <= 1) continue;
            Iterator<E> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (set.add(iterator.next())) continue;
                iterator.remove();
            }
            set.clear();
        }
    }

    void linkExportsIfNeeded(Set<Module> visited) throws ModuleLoadException {
        Paths<LocalLoader, Dependency> paths = this.paths;
        if (paths.getExportedPaths() == null) {
            this.linkExports(paths, visited);
        }
    }

    void relink() throws ModuleLoadException {
        this.linkImports(this.linkExports(this.paths));
    }

    void initializeDependencies(List<DependencySpec> dependencySpecs) throws ModuleLoadException {
        this.paths = new Paths(this.calculateDependencies(dependencySpecs), null, null);
    }

    void setDependencies(List<DependencySpec> dependencySpecs) throws ModuleLoadException {
        this.linkExports(this.paths, this.calculateDependencies(dependencySpecs), new FastCopyHashSet<Module>());
    }

    private Dependency[] calculateDependencies(List<DependencySpec> dependencySpecs) {
        Dependency[] dependencies = new Dependency[dependencySpecs.size()];
        int i = 0;
        for (DependencySpec spec : dependencySpecs) {
            Dependency dependency = spec.getDependency(this);
            dependencies[i++] = dependency;
        }
        return dependencies;
    }

    String getMainClass() {
        return this.mainClassName;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URL.setURLStreamHandlerFactory(new ModularURLStreamHandlerFactory());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    URLConnection.setContentHandlerFactory(new ModularContentHandlerFactory());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        String pkgsString = AccessController.doPrivileged(new PropertyReadAction("jboss.modules.system.pkgs"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("java.");
        list.add("sun.reflect.");
        if (pkgsString != null) {
            int nc = -1;
            do {
                int i;
                String part;
                if ((part = (nc = pkgsString.indexOf(44, i = nc + 1)) == -1 ? pkgsString.substring(i).trim() : pkgsString.substring(i, nc).trim()).length() <= 0) continue;
                list.add((part + ".").intern());
            } while (nc != -1);
        }
        systemPackages = list.toArray(list.toArray(new String[list.size()]));
        ListIterator<String> iterator = list.listIterator();
        while (iterator.hasNext()) {
            iterator.set(((String)iterator.next()).replace('.', '/'));
        }
        systemPaths = list.toArray(list.toArray(new String[list.size()]));
        log = NoopModuleLogger.getInstance();
        NO_DEPENDENCIES = new Dependency[0];
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
        GET_SYSTEM_MODULE = new RuntimePermission("getSystemModule");
        GET_BOOT_MODULE_LOADER = new RuntimePermission("getBootModuleLoader");
        ACCESS_MODULE_LOGGER = new RuntimePermission("accessModuleLogger");
        pathsUpdater = Module.unsafeCast(AtomicReferenceFieldUpdater.newUpdater(Module.class, Paths.class, "paths"));
    }

    private static final class SystemModuleHolder {
        private static final Module SYSTEM;

        private SystemModuleHolder() {
        }

        static {
            try {
                SYSTEM = SystemClassPathModuleLoader.getInstance().loadModule(ModuleIdentifier.SYSTEM);
            }
            catch (ModuleLoadException e) {
                throw e.toError();
            }
        }
    }
}

