/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Iterator;
import java.util.Set;
import org.jboss.modules.PathFilter;

final class SetPathFilter
implements PathFilter {
    private final Set<String> paths;

    SetPathFilter(Set<String> paths) {
        this.paths = paths;
    }

    @Override
    public boolean accept(String path) {
        return this.paths.contains(path);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("in {");
        Iterator<String> iterator = this.paths.iterator();
        while (iterator.hasNext()) {
            String path = iterator.next();
            b.append(path);
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        b.append('}');
        return b.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof SetPathFilter && this.equals((SetPathFilter)obj);
    }

    public boolean equals(SetPathFilter obj) {
        return obj != null && ((Object)obj.paths).equals(this.paths);
    }

    public int hashCode() {
        return ((Object)this.paths).hashCode();
    }
}

