/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleContentLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ResourceLoader;

public final class ModuleSpec {
    private final DependencySpec[] dependencies;
    private final Set<Module.Flag> moduleFlags;
    private final ModuleIdentifier moduleIdentifier;
    private final String mainClass;
    private final ModuleContentLoader loader;
    private final AssertionSetting assertionSetting;

    public ModuleSpec(ModuleIdentifier moduleIdentifier, DependencySpec[] dependencies, ModuleContentLoader loader, Set<Module.Flag> moduleFlags, AssertionSetting assertionSetting, String mainClass) {
        this.moduleIdentifier = moduleIdentifier;
        this.dependencies = dependencies;
        this.loader = loader;
        this.moduleFlags = moduleFlags;
        this.assertionSetting = assertionSetting;
        this.mainClass = mainClass;
    }

    public ModuleIdentifier getIdentifier() {
        return this.moduleIdentifier;
    }

    public DependencySpec[] getDependencies() {
        return this.dependencies;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public ModuleContentLoader getContentLoader() {
        return this.loader;
    }

    public Set<Module.Flag> getModuleFlags() {
        return this.moduleFlags;
    }

    public AssertionSetting getAssertionSetting() {
        return this.assertionSetting;
    }

    public static final Builder build(final ModuleIdentifier moduleIdentifier) {
        return new Builder(){
            private final Set<Module.Flag> moduleFlags = EnumSet.noneOf(Module.Flag.class);
            private String mainClass;
            private AssertionSetting assertionSetting = AssertionSetting.INHERIT;
            private final ModuleContentLoader.Builder moduleContentLoaderBuilder = ModuleContentLoader.build();
            private final Set<DependencySpec.Builder> dependencyBuilders = new HashSet<DependencySpec.Builder>();

            @Override
            public Builder setMainClass(String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            @Override
            public Builder setAssertionSetting(AssertionSetting assertionSetting) {
                this.assertionSetting = assertionSetting;
                return this;
            }

            @Override
            public Builder addModuleFlag(Module.Flag flag) {
                this.moduleFlags.add(flag);
                return this;
            }

            @Override
            public DependencySpec.Builder addDependency(ModuleIdentifier moduleIdentifier2) {
                DependencySpec.Builder dependencySpecBuilder = DependencySpec.build(moduleIdentifier2);
                this.dependencyBuilders.add(dependencySpecBuilder);
                return dependencySpecBuilder;
            }

            @Override
            public Builder addRoot(String rootName, ResourceLoader resourceLoader) {
                this.moduleContentLoaderBuilder.add(rootName, resourceLoader);
                return this;
            }

            @Override
            public ModuleSpec create() {
                ModuleContentLoader.Builder moduleContentLoaderBuilder = this.moduleContentLoaderBuilder;
                Set<DependencySpec.Builder> dependencyBuilders = this.dependencyBuilders;
                DependencySpec[] dependencySpecs = new DependencySpec[dependencyBuilders.size()];
                int i = 0;
                for (DependencySpec.Builder dependencyBuilder : dependencyBuilders) {
                    dependencySpecs[i++] = dependencyBuilder.create();
                }
                return new ModuleSpec(moduleIdentifier, dependencySpecs, moduleContentLoaderBuilder.create(), this.moduleFlags, this.assertionSetting, this.mainClass);
            }

            @Override
            public ModuleIdentifier getIdentifier() {
                return moduleIdentifier;
            }
        };
    }

    public static interface Builder {
        public Builder setMainClass(String var1);

        public Builder setAssertionSetting(AssertionSetting var1);

        public Builder addModuleFlag(Module.Flag var1);

        public DependencySpec.Builder addDependency(ModuleIdentifier var1);

        public Builder addRoot(String var1, ResourceLoader var2);

        public ModuleSpec create();

        public ModuleIdentifier getIdentifier();
    }
}

