/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.ExportFilter;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;

public final class ModuleContentLoader {
    private final Map<String, ResourceLoader> resourceLoaders;
    private final Set<String> localPaths;
    private final Set<String> filteredLocalPaths;
    public static final ModuleContentLoader EMPTY = new ModuleContentLoader(Collections.<String, ResourceLoader>emptyMap());

    private ModuleContentLoader(Map<String, ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
        LinkedHashSet<String> localPaths = new LinkedHashSet<String>();
        HashSet<String> filteredLocalPaths = new HashSet<String>();
        for (ResourceLoader rl : resourceLoaders.values()) {
            Collection<String> rlPaths = rl.getPaths();
            ExportFilter exportFilter = rl.getExportFilter();
            for (String localPath : rlPaths) {
                localPaths.add(localPath);
                if (!exportFilter.shouldExport(localPath)) continue;
                filteredLocalPaths.add(localPath);
            }
        }
        this.localPaths = localPaths;
        this.filteredLocalPaths = filteredLocalPaths;
    }

    public static Builder build() {
        return new Builder(){
            private final Map<String, ResourceLoader> map = new LinkedHashMap<String, ResourceLoader>();

            @Override
            public Builder add(String rootName, ResourceLoader loader) {
                this.map.put(rootName, loader);
                return this;
            }

            @Override
            public ModuleContentLoader create() {
                return new ModuleContentLoader(new LinkedHashMap<String, ResourceLoader>(this.map));
            }
        };
    }

    public ResourceLoader getResourceLoader(String root) {
        return this.resourceLoaders.get(root);
    }

    public Resource getResource(String name) {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            Resource resource = resourceLoader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public Resource getResource(String root, String name) {
        ResourceLoader resourceLoader = this.resourceLoaders.get(root);
        if (resourceLoader != null) {
            return resourceLoader.getResource(name);
        }
        return null;
    }

    public Iterable<Resource> getResources(String name) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            Resource resource = resourceLoader.getResource(name);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources;
    }

    public ClassSpec getClassSpec(String className) throws IOException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            ClassSpec classSpec = resourceLoader.getClassSpec(className);
            if (classSpec == null) continue;
            return classSpec;
        }
        return null;
    }

    public PackageSpec getPackageSpec(String packageName) throws IOException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            PackageSpec packageSpec = resourceLoader.getPackageSpec(packageName);
            if (packageSpec == null) continue;
            return packageSpec;
        }
        return null;
    }

    public String getLibrary(String libname) {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            String res = resourceLoader.getLibrary(libname);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Set<String> getLocalPaths() {
        return this.localPaths;
    }

    public Set<String> getFilteredLocalPaths() {
        return this.filteredLocalPaths;
    }

    public static interface Builder {
        public Builder add(String var1, ResourceLoader var2);

        public ModuleContentLoader create();
    }
}

