/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.Dependency;
import org.jboss.modules.InitialModuleLoader;
import org.jboss.modules.ModularURLStreamHandlerFactory;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleLoaderSelector;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.SystemModuleClassLoader;

public final class Module {
    public static final Module SYSTEM;
    private static ModuleLoaderSelector moduleLoaderSelector;
    private final ModuleIdentifier identifier;
    private final String mainClassName;
    private final ModuleClassLoader moduleClassLoader;
    private final ModuleLoader moduleLoader;
    private final Set<String> exportedPaths;
    private final Map<String, List<DependencyImport>> pathsToImports;

    Module(ModuleSpec spec, Set<Flag> flags, ModuleLoader moduleLoader, Set<String> exportedPaths, Map<String, List<DependencyImport>> pathsToImports) {
        this.moduleLoader = moduleLoader;
        this.identifier = spec.getIdentifier();
        this.mainClassName = spec.getMainClass();
        this.moduleClassLoader = new ModuleClassLoader(this, flags, spec.getAssertionSetting(), spec.getContentLoader());
        this.exportedPaths = exportedPaths;
        this.pathsToImports = pathsToImports;
    }

    private Module() {
        this.identifier = ModuleIdentifier.SYSTEM;
        this.mainClassName = null;
        SystemModuleClassLoader smcl = new SystemModuleClassLoader(this, Collections.<Flag>emptySet(), AssertionSetting.INHERIT);
        this.moduleClassLoader = smcl;
        this.exportedPaths = smcl.getExportedPaths();
        this.pathsToImports = null;
        this.moduleLoader = InitialModuleLoader.INSTANCE;
    }

    public final Resource getExportedResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.getRawResource(rootPath, resourcePath);
    }

    public final void run(String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        try {
            if (this.mainClassName == null) {
                throw new NoSuchMethodException("No main class defined for " + this);
            }
            Class<?> mainClass = this.moduleClassLoader.loadExportedClass(this.mainClassName);
            if (mainClass == null) {
                throw new NoSuchMethodException("No main class named '" + this.mainClassName + "' found in " + this);
            }
            Method mainMethod = mainClass.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new NoSuchMethodException("Main method is not static for " + this);
            }
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public <S> ServiceLoader<S> loadService(Class<S> serviceType) {
        return ServiceLoader.load(serviceType, this.moduleClassLoader);
    }

    public static <S> ServiceLoader<S> loadService(ModuleIdentifier moduleIdentifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.getModule(moduleIdentifier).loadService(serviceType);
    }

    public static <S> ServiceLoader<S> loadService(String moduleIdentifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.loadService(ModuleIdentifier.fromString(moduleIdentifier), serviceType);
    }

    public ModuleClassLoader getClassLoader() {
        return this.moduleClassLoader;
    }

    public Set<String> getExportedPaths() {
        return this.exportedPaths;
    }

    public static Module forClass(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        return cl instanceof ModuleClassLoader ? ((ModuleClassLoader)cl).getModule() : null;
    }

    public static Class<?> loadClass(ModuleIdentifier moduleIdentifier, String className, boolean initialize) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, initialize, ModuleClassLoader.forModule(moduleIdentifier));
    }

    public static Class<?> loadClass(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, ModuleClassLoader.forModule(moduleIdentifier));
    }

    public static Class<?> loadClass(String moduleIdentifierString, String className, boolean initialize) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, initialize, ModuleClassLoader.forModule(ModuleIdentifier.fromString(moduleIdentifierString)));
    }

    public static Class<?> loadClass(String moduleIdentifierString, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, ModuleClassLoader.forModule(ModuleIdentifier.fromString(moduleIdentifierString)));
    }

    public static Module getModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return moduleLoaderSelector.getCurrentLoader().loadModule(identifier);
    }

    public String toString() {
        return "Module \"" + this.identifier + "\"";
    }

    public static void setModuleLoaderSelector(ModuleLoaderSelector moduleLoaderSelector) {
        if (moduleLoaderSelector == null) {
            throw new IllegalArgumentException("ModuleLoaderSelector can not be null");
        }
        Module.moduleLoaderSelector = moduleLoaderSelector;
    }

    Map<String, List<DependencyImport>> getPathsToImports() {
        return this.pathsToImports;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                URL.setURLStreamHandlerFactory(new ModularURLStreamHandlerFactory());
                return null;
            }
        });
        SYSTEM = new Module();
        moduleLoaderSelector = ModuleLoaderSelector.DEFAULT;
    }

    static class DependencyImport {
        private final Dependency dependency;
        private final boolean export;

        DependencyImport(Dependency dependency, boolean export) {
            this.dependency = dependency;
            this.export = export;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public boolean isExport() {
            return this.export;
        }
    }

    public static enum Flag {
        CHILD_FIRST;

    }
}

