/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.JarEntryResource;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;

final class JarFileResourceLoader
extends AbstractResourceLoader {
    private final ModuleIdentifier moduleIdentifier;
    private final JarFile jarFile;
    private final String rootName;

    JarFileResourceLoader(ModuleIdentifier moduleIdentifier, JarFile jarFile, String rootName) {
        this.jarFile = jarFile;
        this.rootName = rootName;
        this.moduleIdentifier = moduleIdentifier;
    }

    @Override
    public ClassSpec getClassSpec(String name) throws IOException {
        String fileName = name.replace('.', '/') + ".class";
        ClassSpec spec = new ClassSpec();
        JarEntry entry = this.jarFile.getJarEntry(fileName);
        if (entry == null) {
            return null;
        }
        CodeSigner[] codeSigners = entry.getCodeSigners();
        if (codeSigners != null) {
            spec.setCodeSource(new CodeSource(this.moduleIdentifier.toURL(this.rootName), codeSigners));
        }
        long size = entry.getSize();
        InputStream is = this.jarFile.getInputStream(entry);
        try {
            if (size == -1L) {
                int res;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[16384];
                while ((res = is.read(buf)) > 0) {
                    baos.write(buf, 0, res);
                }
                baos.close();
                is.close();
                spec.setBytes(baos.toByteArray());
                ClassSpec classSpec = spec;
                return classSpec;
            }
            if (size <= Integer.MAX_VALUE) {
                int res;
                int castSize = (int)size;
                byte[] bytes = new byte[castSize];
                int a = 0;
                while ((res = is.read(bytes, a, castSize - a)) > 0) {
                    a += res;
                }
                is.close();
                spec.setBytes(bytes);
                ClassSpec classSpec = spec;
                return classSpec;
            }
            throw new IOException("Resource is too large to be a valid class file");
        }
        finally {
            JarFileResourceLoader.safeClose(is);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        PackageSpec spec = new PackageSpec();
        Manifest manifest = this.jarFile.getManifest();
        if (manifest == null) {
            return spec;
        }
        Attributes mainAttribute = manifest.getMainAttributes();
        Attributes entryAttribute = manifest.getAttributes(name);
        spec.setSpecTitle(JarFileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_TITLE, entryAttribute, mainAttribute));
        spec.setSpecVersion(JarFileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VERSION, entryAttribute, mainAttribute));
        spec.setSpecVendor(JarFileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VENDOR, entryAttribute, mainAttribute));
        spec.setImplTitle(JarFileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_TITLE, entryAttribute, mainAttribute));
        spec.setImplVersion(JarFileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VERSION, entryAttribute, mainAttribute));
        spec.setImplVendor(JarFileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttribute, mainAttribute));
        if (Boolean.parseBoolean(JarFileResourceLoader.getDefinedAttribute(Attributes.Name.SEALED, entryAttribute, mainAttribute))) {
            spec.setSealBase(this.moduleIdentifier.toURL(this.rootName));
        }
        return spec;
    }

    private static String getDefinedAttribute(Attributes.Name name, Attributes entryAttribute, Attributes mainAttribute) {
        String value;
        String string = value = entryAttribute == null ? null : entryAttribute.getValue(name);
        return value == null ? (mainAttribute == null ? null : mainAttribute.getValue(name)) : value;
    }

    @Override
    public String getLibrary(String name) {
        return null;
    }

    @Override
    public Resource getResource(String name) {
        try {
            JarEntry entry;
            JarFile jarFile = this.jarFile;
            String entryName = name;
            if (entryName.startsWith("/")) {
                entryName = entryName.substring(1);
            }
            if ((entry = jarFile.getJarEntry(entryName)) == null) {
                return null;
            }
            return new JarEntryResource(jarFile, entry, this.moduleIdentifier.toURL(this.rootName, name));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPaths() {
        JarEntry indexListEntry;
        LinkedHashSet<String> index = new LinkedHashSet<String>();
        JarFile jarFile = this.jarFile;
        String jarFileName = jarFile.getName();
        File indexFile = new File(jarFileName + ".index");
        if (indexFile.exists()) {
            LinkedHashSet<String> linkedHashSet;
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(indexFile)));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    index.add(s.trim());
                }
                linkedHashSet = index;
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    index.clear();
                }
            }
            r.close();
            return linkedHashSet;
        }
        if ((indexListEntry = jarFile.getJarEntry("META-INF/INDEX.LIST")) != null) {
            LinkedHashSet<String> linkedHashSet;
            BufferedReader r = new BufferedReader(new InputStreamReader(jarFile.getInputStream(indexListEntry)));
            try {
                String s = r.readLine();
                if (s != null && !s.startsWith("JarIndex-Version: ")) {
                    throw new IOException();
                }
                s = r.readLine();
                if (s != null && s.trim().length() != 0) {
                    throw new IOException();
                }
                int idx = Math.max(jarFileName.lastIndexOf(47), jarFileName.lastIndexOf(92));
                String ourJarName = jarFileName.substring(idx + 1);
                boolean ok = false;
                while ((s = r.readLine()) != null) {
                    String foundJarName = s.substring(s.lastIndexOf(47) + 1).trim();
                    if (foundJarName.equals(ourJarName)) {
                        ok = true;
                        break;
                    }
                    while ((s = r.readLine()) != null && s.trim().length() != 0) {
                    }
                }
                if (!ok) {
                    throw new IOException();
                }
                while ((s = r.readLine()) != null && s.trim().length() != 0) {
                    index.add(s.trim());
                }
                linkedHashSet = index;
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    index.clear();
                }
            }
            r.close();
            return linkedHashSet;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String path;
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            int idx = name.lastIndexOf(47);
            if (idx == -1 || (path = name.substring(0, idx)).length() == 0 || path.endsWith("/")) continue;
            index.add(path);
        }
        boolean ok = false;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(indexFile)));
            try {
                for (String name : index) {
                    writer.write(name);
                    writer.write(10);
                }
                writer.close();
                ok = true;
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
        }
        finally {
            if (!ok) {
                indexFile.delete();
            }
        }
        return index;
    }
}

