/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.Server;
import org.jboss.modcluster.container.tomcat.ConnectorFactory;
import org.jboss.modcluster.container.tomcat.ContextFactory;
import org.jboss.modcluster.container.tomcat.EngineFactory;
import org.jboss.modcluster.container.tomcat.HostFactory;
import org.jboss.modcluster.container.tomcat.ProxyConnectorProvider;
import org.jboss.modcluster.container.tomcat.ServerFactory;
import org.jboss.modcluster.container.tomcat.TomcatConnectorFactory;
import org.jboss.modcluster.container.tomcat.TomcatContextFactory;
import org.jboss.modcluster.container.tomcat.TomcatEngineFactory;
import org.jboss.modcluster.container.tomcat.TomcatFactory;
import org.jboss.modcluster.container.tomcat.TomcatFactoryRegistry;
import org.jboss.modcluster.container.tomcat.TomcatHostFactory;
import org.jboss.modcluster.container.tomcat.TomcatServerFactory;

public class ServiceLoaderTomcatFactory
implements TomcatFactory,
TomcatFactoryRegistry {
    private final ServerFactory serverFactory;
    private final EngineFactory engineFactory;
    private final HostFactory hostFactory;
    private final ContextFactory contextFactory;
    private final ConnectorFactory connectorFactory;
    private final ProxyConnectorProvider provider;

    static <T> T load(final Class<T> targetClass, final Class<? extends T> defaultClass) {
        PrivilegedAction action = new PrivilegedAction<T>(){

            @Override
            public T run() {
                Iterator iterator = ServiceLoader.load(targetClass, targetClass.getClassLoader()).iterator();
                if (iterator.hasNext()) {
                    Object value = iterator.next();
                    return value;
                }
                try {
                    return defaultClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        return AccessController.doPrivileged(action);
    }

    public ServiceLoaderTomcatFactory(ProxyConnectorProvider provider) {
        this.serverFactory = ServiceLoaderTomcatFactory.load(ServerFactory.class, TomcatServerFactory.class);
        this.engineFactory = ServiceLoaderTomcatFactory.load(EngineFactory.class, TomcatEngineFactory.class);
        this.hostFactory = ServiceLoaderTomcatFactory.load(HostFactory.class, TomcatHostFactory.class);
        this.contextFactory = ServiceLoaderTomcatFactory.load(ContextFactory.class, TomcatContextFactory.class);
        this.connectorFactory = ServiceLoaderTomcatFactory.load(ConnectorFactory.class, TomcatConnectorFactory.class);
        this.provider = provider;
    }

    public ServiceLoaderTomcatFactory(ServerFactory serverFactory, EngineFactory engineFactory, HostFactory hostFactory, ContextFactory contextFactory, ConnectorFactory connectorFactory, ProxyConnectorProvider provider) {
        this.serverFactory = serverFactory;
        this.engineFactory = engineFactory;
        this.hostFactory = hostFactory;
        this.contextFactory = contextFactory;
        this.connectorFactory = connectorFactory;
        this.provider = provider;
    }

    @Override
    public Server createServer(org.apache.catalina.Server server) {
        return this.serverFactory.createServer(this, server);
    }

    @Override
    public Engine createEngine(org.apache.catalina.Engine engine) {
        return this.engineFactory.createEngine(this, engine, this.createServer(engine.getService().getServer()));
    }

    @Override
    public Host createHost(org.apache.catalina.Host host) {
        return this.hostFactory.createHost(this, host, this.createEngine((org.apache.catalina.Engine)host.getParent()));
    }

    @Override
    public Context createContext(org.apache.catalina.Context context) {
        return this.contextFactory.createContext(context, this.createHost((org.apache.catalina.Host)context.getParent()));
    }

    @Override
    public ProxyConnectorProvider getProxyConnectorProvider() {
        return this.provider;
    }

    @Override
    public ServerFactory getServerFactory() {
        return this.serverFactory;
    }

    @Override
    public EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    @Override
    public HostFactory getHostFactory() {
        return this.hostFactory;
    }

    @Override
    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    @Override
    public ConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }
}

