/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.tomcat.RequestListenerValveFactory;

public class TomcatContext
implements Context {
    private final RequestListenerValveFactory valveFactory;
    protected final org.apache.catalina.Context context;
    protected final Host host;

    public TomcatContext(org.apache.catalina.Context context, Host host, RequestListenerValveFactory valveFactory) {
        this.context = context;
        this.host = host;
        this.valveFactory = valveFactory;
    }

    public TomcatContext(org.apache.catalina.Context context, Host host) {
        this(context, host, new RequestListenerValveFactory(){

            @Override
            public Valve createValve(ServletRequestListener listener) {
                return new RequestListenerValve(listener);
            }
        });
    }

    public Host getHost() {
        return this.host;
    }

    public String getPath() {
        return this.context.getPath();
    }

    public boolean isStarted() {
        return LifecycleState.STARTED.equals((Object)this.context.getState());
    }

    public void addRequestListener(ServletRequestListener listener) {
        if (this.valveFactory != null) {
            this.context.getPipeline().addValve(this.valveFactory.createValve(listener));
        }
    }

    public void removeRequestListener(ServletRequestListener listener) {
        if (this.valveFactory != null) {
            Valve listenerValve = this.valveFactory.createValve(listener);
            Pipeline pipeline = this.context.getPipeline();
            for (Valve valve : pipeline.getValves()) {
                if (!listenerValve.equals(valve)) continue;
                pipeline.removeValve(valve);
                break;
            }
        }
    }

    public int getActiveSessionCount() {
        return this.context.getManager().getActiveSessions();
    }

    public boolean isDistributable() {
        return this.context.getDistributable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(HttpSessionListener listener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            this.context.setApplicationLifecycleListeners(this.addListener(listener, this.context.getApplicationLifecycleListeners()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(HttpSessionListener listener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            this.context.setApplicationLifecycleListeners(this.removeListener(listener, this.context.getApplicationLifecycleListeners()));
        }
    }

    private Object[] addListener(Object listener, Object[] listeners) {
        if (listeners == null) {
            return new Object[]{listener};
        }
        ArrayList<Object> listenerList = new ArrayList<Object>(listeners.length + 1);
        listenerList.add(listener);
        listenerList.addAll(Arrays.asList(listeners));
        return listenerList.toArray();
    }

    private Object[] removeListener(Object listener, Object[] listeners) {
        if (listeners == null) {
            return null;
        }
        ArrayList<Object> listenerList = new ArrayList<Object>(listeners.length - 1);
        for (Object existingListener : listeners) {
            if (existingListener.equals(listener)) continue;
            listenerList.add(existingListener);
        }
        return listenerList.toArray();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TomcatContext)) {
            return false;
        }
        TomcatContext context = (TomcatContext)object;
        return this.context == context.context;
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public String toString() {
        return this.context.getPath();
    }

    private static class RequestListenerValve
    extends ValveBase {
        private final ServletRequestListener listener;

        RequestListenerValve(ServletRequestListener listener) {
            this.listener = listener;
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            this.event(request, response, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
            ServletRequestEvent requestEvent = new ServletRequestEvent(request.getContext().getServletContext(), (ServletRequest)request);
            this.listener.requestInitialized(requestEvent);
            Valve valve = this.getNext();
            try {
                if (event != null) {
                    valve.event(request, response, event);
                } else {
                    valve.invoke(request, response);
                }
            }
            finally {
                this.listener.requestDestroyed(requestEvent);
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof RequestListenerValve)) {
                return false;
            }
            RequestListenerValve valve = (RequestListenerValve)((Object)object);
            return this.listener == valve.listener;
        }
    }
}

