/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.catalina.Engine;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.tomcat.ConnectorFactory;
import org.jboss.modcluster.container.tomcat.ProxyConnectorProvider;
import org.jboss.modcluster.container.tomcat.TomcatConnectorConfiguration;

public class ConfigurableProxyConnectorProvider
implements ProxyConnectorProvider {
    private final TomcatConnectorConfiguration connectorConfiguration;

    public ConfigurableProxyConnectorProvider(TomcatConnectorConfiguration connectorConfiguration) {
        this.connectorConfiguration = connectorConfiguration;
    }

    @Override
    public Connector createProxyConnector(ConnectorFactory factory, Engine engine) {
        String connectorAddress = this.connectorConfiguration.getConnectorAddress();
        Integer connectorPort = this.connectorConfiguration.getConnectorPort();
        org.apache.catalina.connector.Connector candidate = null;
        for (org.apache.catalina.connector.Connector connector : engine.getService().findConnectors()) {
            if (connectorPort != null && !connectorPort.equals(connector.getPort())) continue;
            String resolvedConfiguredAddress = null;
            String addressInTomcat = null;
            if (connector != null) {
                Object addressObj = connector.getProperty("address");
                if (addressObj instanceof InetAddress) {
                    addressInTomcat = ((InetAddress)addressObj).getHostAddress();
                } else if (addressObj != null) {
                    addressInTomcat = addressObj.toString();
                }
                try {
                    resolvedConfiguredAddress = InetAddress.getByName(connectorAddress).getHostAddress();
                }
                catch (UnknownHostException e) {
                    throw ModClusterLogger.LOGGER.connectorAddressUnknownHost(connectorAddress);
                }
            }
            if (connectorAddress != null && !resolvedConfiguredAddress.equalsIgnoreCase(addressInTomcat)) continue;
            if (candidate == null) {
                candidate = connector;
                continue;
            }
            throw ModClusterLogger.LOGGER.connectorMatchesMultiple(ConfigurableProxyConnectorProvider.format(connectorAddress, connectorPort));
        }
        if (candidate == null) {
            throw ModClusterLogger.LOGGER.connectorNoMatch(ConfigurableProxyConnectorProvider.format(connectorAddress, connectorPort));
        }
        return factory.createConnector(candidate);
    }

    private static String format(String connectorAddress, Integer connectorPort) {
        return (connectorAddress == null ? "*" : connectorAddress) + ":" + (connectorPort == null ? "*" : connectorPort);
    }
}

