/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.listeners.HttpSessionListener;
import org.jboss.modcluster.container.listeners.ServletRequestListener;
import org.jboss.modcluster.container.tomcat.JavaxHttpSessionListener;
import org.jboss.modcluster.container.tomcat.RequestListenerValveFactory;
import org.jboss.modcluster.container.tomcat.TomcatHost;
import org.jboss.modcluster.container.tomcat.TomcatRegistry;

public class TomcatContext
implements Context {
    private final RequestListenerValveFactory valveFactory;
    protected final org.apache.catalina.Context context;
    protected final Host host;
    protected final TomcatRegistry registry;

    public TomcatContext(TomcatRegistry registry, org.apache.catalina.Context context, RequestListenerValveFactory valveFactory) {
        this.registry = registry;
        this.context = context;
        this.host = new TomcatHost(registry, (org.apache.catalina.Host)context.getParent());
        this.valveFactory = valveFactory;
    }

    public TomcatContext(TomcatRegistry registry, org.apache.catalina.Context context) {
        this(registry, context, RequestListenerValve::new);
    }

    public Host getHost() {
        return this.host;
    }

    public String getPath() {
        return this.context.getPath();
    }

    public boolean isStarted() {
        return LifecycleState.STARTED == this.context.getState();
    }

    public void addRequestListener(ServletRequestListener requestListener) {
        if (this.valveFactory != null) {
            this.context.getPipeline().addValve(this.valveFactory.createValve(requestListener));
        }
    }

    public void removeRequestListener(ServletRequestListener requestListener) {
        if (this.valveFactory != null) {
            Valve listenerValve = this.valveFactory.createValve(requestListener);
            Pipeline pipeline = this.context.getPipeline();
            for (Valve valve : pipeline.getValves()) {
                if (!listenerValve.equals(valve)) continue;
                pipeline.removeValve(valve);
                break;
            }
        }
    }

    public int getActiveSessionCount() {
        return this.context.getManager().getActiveSessions();
    }

    public boolean isDistributable() {
        return this.context.getDistributable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(HttpSessionListener sessionListener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            this.context.setApplicationLifecycleListeners(this.addListener(this.adaptSessionListener(sessionListener), this.context.getApplicationLifecycleListeners()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(HttpSessionListener sessionListener) {
        org.apache.catalina.Context context = this.context;
        synchronized (context) {
            this.context.setApplicationLifecycleListeners(this.removeListener(this.adaptSessionListener(sessionListener), this.context.getApplicationLifecycleListeners()));
        }
    }

    public Object adaptSessionListener(HttpSessionListener sessionListener) {
        return new JavaxHttpSessionListener(sessionListener);
    }

    private Object[] addListener(Object listener, Object[] listeners) {
        if (listeners == null) {
            return new Object[]{listener};
        }
        ArrayList<Object> listenerList = new ArrayList<Object>(listeners.length + 1);
        listenerList.add(listener);
        listenerList.addAll(Arrays.asList(listeners));
        return listenerList.toArray();
    }

    private Object[] removeListener(Object listener, Object[] listeners) {
        if (listeners == null) {
            return null;
        }
        ArrayList<Object> listenerList = new ArrayList<Object>(listeners.length - 1);
        for (Object existingListener : listeners) {
            if (existingListener.equals(listener)) continue;
            listenerList.add(existingListener);
        }
        return listenerList.toArray();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TomcatContext)) {
            return false;
        }
        TomcatContext context = (TomcatContext)object;
        return this.context == context.context;
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public String toString() {
        return this.context.getPath();
    }

    private static class RequestListenerValve
    extends ValveBase {
        private final ServletRequestListener listener;

        RequestListenerValve(ServletRequestListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Request request, Response response) throws IOException, ServletException {
            this.listener.requestInitialized();
            Valve valve = this.getNext();
            try {
                valve.invoke(request, response);
            }
            finally {
                this.listener.requestDestroyed();
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RequestListenerValve)) {
                return false;
            }
            RequestListenerValve valve = (RequestListenerValve)((Object)object);
            return this.listener == valve.listener;
        }
    }
}

