/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.catalina.Service;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Server;
import org.jboss.modcluster.container.tomcat.TomcatEngine;
import org.jboss.modcluster.container.tomcat.TomcatRegistry;

public class TomcatServer
implements Server {
    protected final TomcatRegistry registry;
    protected final org.apache.catalina.Server server;

    public TomcatServer(TomcatRegistry registry, org.apache.catalina.Server server) {
        this.registry = registry;
        this.server = server;
    }

    public Iterable<Engine> getEngines() {
        final Iterator<Service> services = Arrays.asList(this.server.findServices()).iterator();
        final Iterator<Engine> engines = new Iterator<Engine>(){

            @Override
            public boolean hasNext() {
                return services.hasNext();
            }

            @Override
            public Engine next() {
                return new TomcatEngine(TomcatServer.this.registry, ((Service)services.next()).getContainer());
            }

            @Override
            public void remove() {
                services.remove();
            }
        };
        return new Iterable<Engine>(){

            @Override
            public Iterator<Engine> iterator() {
                return engines;
            }
        };
    }

    public boolean equals(Object object) {
        if (!(object instanceof TomcatServer)) {
            return false;
        }
        TomcatServer server = (TomcatServer)object;
        return this.server == server.server;
    }

    public int hashCode() {
        return this.server.hashCode();
    }

    public String toString() {
        return this.server.getClass().getName();
    }
}

