/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Server;
import org.jboss.modcluster.container.tomcat.ConfigurableProxyConnectorProvider;
import org.jboss.modcluster.container.tomcat.JMXServerProvider;
import org.jboss.modcluster.container.tomcat.ServerProvider;
import org.jboss.modcluster.container.tomcat.SingleServiceServer;
import org.jboss.modcluster.container.tomcat.TomcatConnectorConfiguration;
import org.jboss.modcluster.container.tomcat.TomcatContext;
import org.jboss.modcluster.container.tomcat.TomcatEngine;
import org.jboss.modcluster.container.tomcat.TomcatEventHandler;
import org.jboss.modcluster.container.tomcat.TomcatRegistry;
import org.jboss.modcluster.container.tomcat.TomcatServer;

public class TomcatEventHandlerAdapter
implements TomcatEventHandler {
    private static final int STATUS_FREQUENCY = Integer.parseInt(System.getProperty("org.jboss.modcluster.container.catalina.status-frequency", "1"));
    protected final ContainerEventHandler eventHandler;
    protected final ServerProvider serverProvider;
    protected final TomcatRegistry registry;
    protected final AtomicBoolean init = new AtomicBoolean(false);
    protected final AtomicBoolean start = new AtomicBoolean(false);
    private volatile int statusCount = 0;

    public TomcatEventHandlerAdapter(ContainerEventHandler eventHandler, TomcatConnectorConfiguration connectorConfiguration) {
        this(eventHandler, new JMXServerProvider(ManagementFactory.getPlatformMBeanServer(), TomcatEventHandlerAdapter.toObjectName("Catalina:type=Server")), () -> new ConfigurableProxyConnectorProvider(connectorConfiguration));
    }

    TomcatEventHandlerAdapter(ContainerEventHandler eventHandler, ServerProvider serverProvider, TomcatRegistry registry) {
        this.eventHandler = eventHandler;
        this.serverProvider = serverProvider;
        this.registry = registry;
    }

    @Override
    public void start() {
        org.apache.catalina.Server server = this.serverProvider.getServer();
        if (server == null) {
            throw new IllegalStateException();
        }
        if (!this.containsListener((Lifecycle)server)) {
            server.addLifecycleListener((LifecycleListener)this);
        }
        if (this.init.compareAndSet(false, true)) {
            this.init(server);
        }
        if (this.start.compareAndSet(false, true)) {
            this.eventHandler.start((Server)new TomcatServer(this.registry, server));
        }
    }

    @Override
    public void stop() {
        org.apache.catalina.Server server = this.serverProvider.getServer();
        if (server == null) {
            throw new IllegalStateException();
        }
        server.removeLifecycleListener((LifecycleListener)this);
        if (this.init.get() && this.start.compareAndSet(true, false)) {
            this.eventHandler.stop((Server)new TomcatServer(this.registry, server));
        }
        if (this.init.compareAndSet(true, false)) {
            this.destroy(server);
        }
    }

    private boolean containsListener(Lifecycle lifecycle) {
        for (LifecycleListener listener : lifecycle.findLifecycleListeners()) {
            if (!listener.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener((LifecycleListener)this);
                ((Container)child).addPropertyChangeListener((PropertyChangeListener)this);
                if (this.start.get()) {
                    this.eventHandler.add((Context)new TomcatContext(this.registry, (org.apache.catalina.Context)child));
                }
            } else if (container instanceof org.apache.catalina.Engine) {
                container.addContainerListener((ContainerListener)this);
                if (child != null) {
                    ((Host)child).addContainerListener((ContainerListener)this);
                }
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener((LifecycleListener)this);
                ((Container)child).removePropertyChangeListener((PropertyChangeListener)this);
                if (this.start.get()) {
                    this.eventHandler.remove((Context)new TomcatContext(this.registry, (org.apache.catalina.Context)child));
                }
            } else if (container instanceof org.apache.catalina.Engine) {
                if (child != null) {
                    ((Host)child).removeContainerListener((ContainerListener)this);
                }
                container.removeContainerListener((ContainerListener)this);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        String type = event.getType();
        if (this.isAfterInit(event)) {
            if (source instanceof org.apache.catalina.Server) {
                if (this.init.compareAndSet(false, true)) {
                    org.apache.catalina.Server server = (org.apache.catalina.Server)source;
                    this.init(server);
                }
            } else if (source instanceof Service && this.init.compareAndSet(false, true)) {
                SingleServiceServer server = new SingleServiceServer((Service)source);
                this.init(server);
            }
        } else if (type.equals("start")) {
            if (source instanceof org.apache.catalina.Server) {
                if (this.init.compareAndSet(false, true)) {
                    org.apache.catalina.Server server = (org.apache.catalina.Server)source;
                    this.init(server);
                }
            } else if (source instanceof Service && this.init.compareAndSet(false, true)) {
                SingleServiceServer server = new SingleServiceServer((Service)source);
                this.init(server);
            }
        } else if (type.equals("after_start")) {
            if (source instanceof org.apache.catalina.Server) {
                if (this.init.get() && this.start.compareAndSet(false, true)) {
                    this.eventHandler.start((Server)new TomcatServer(this.registry, (org.apache.catalina.Server)source));
                }
            } else if (source instanceof Service) {
                if (this.init.get() && this.start.compareAndSet(false, true)) {
                    SingleServiceServer server = new SingleServiceServer((Service)source);
                    this.eventHandler.start((Server)new TomcatServer(this.registry, server));
                }
            } else if (source instanceof org.apache.catalina.Context) {
                this.eventHandler.start((Context)new TomcatContext(this.registry, (org.apache.catalina.Context)source));
            }
        } else if (type.equals("before_stop")) {
            if (source instanceof org.apache.catalina.Context) {
                if (this.start.get()) {
                    this.eventHandler.stop((Context)new TomcatContext(this.registry, (org.apache.catalina.Context)source));
                }
            } else if (source instanceof org.apache.catalina.Server) {
                if (this.init.get() && this.start.compareAndSet(true, false)) {
                    this.eventHandler.stop((Server)new TomcatServer(this.registry, (org.apache.catalina.Server)source));
                }
            } else if (source instanceof Service && this.init.get() && this.start.compareAndSet(true, false)) {
                SingleServiceServer server = new SingleServiceServer((Service)source);
                this.eventHandler.stop((Server)new TomcatServer(this.registry, server));
            }
        } else if (this.isBeforeDestroy(event)) {
            if (source instanceof org.apache.catalina.Server) {
                if (this.init.compareAndSet(true, false)) {
                    this.destroy((org.apache.catalina.Server)source);
                }
            } else if (source instanceof Service && this.init.compareAndSet(true, false)) {
                SingleServiceServer server = new SingleServiceServer((Service)source);
                this.destroy(server);
            }
        } else if (type.equals("periodic") && source instanceof org.apache.catalina.Engine) {
            org.apache.catalina.Engine engine = (org.apache.catalina.Engine)source;
            this.statusCount = (this.statusCount + 1) % STATUS_FREQUENCY;
            if (this.statusCount == 0 && this.start.get()) {
                this.eventHandler.status((Engine)new TomcatEngine(this.registry, engine));
            }
        }
    }

    protected boolean isAfterInit(LifecycleEvent event) {
        return event.getType().equals("after_init");
    }

    protected boolean isBeforeDestroy(LifecycleEvent event) {
        return event.getType().equals("before_destroy");
    }

    protected void init(org.apache.catalina.Server server) {
        this.eventHandler.init((Server)new TomcatServer(this.registry, server));
        this.addListeners(server);
    }

    protected void destroy(org.apache.catalina.Server server) {
        this.removeListeners(server);
        this.eventHandler.shutdown();
    }

    protected void addListeners(org.apache.catalina.Server server) {
        for (Service service : server.findServices()) {
            org.apache.catalina.Engine engine = service.getContainer();
            engine.addContainerListener((ContainerListener)this);
            engine.addLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.addContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    context.addLifecycleListener((LifecycleListener)this);
                    context.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    protected void removeListeners(org.apache.catalina.Server server) {
        for (Service service : server.findServices()) {
            org.apache.catalina.Engine engine = service.getContainer();
            engine.removeContainerListener((ContainerListener)this);
            engine.removeLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.removeContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    context.removeLifecycleListener((LifecycleListener)this);
                    context.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    }

    protected static ObjectName toObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof org.apache.catalina.Context && "available".equals(event.getPropertyName()) && Boolean.FALSE.equals(event.getOldValue()) && Boolean.TRUE.equals(event.getNewValue())) {
            this.eventHandler.start((Context)new TomcatContext(this.registry, (org.apache.catalina.Context)event.getSource()));
        }
    }
}

