/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.tomcat;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.catalina.Container;
import org.apache.catalina.util.SessionConfig;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.Server;
import org.jboss.modcluster.container.tomcat.TomcatConnector;
import org.jboss.modcluster.container.tomcat.TomcatHost;
import org.jboss.modcluster.container.tomcat.TomcatRegistry;
import org.jboss.modcluster.container.tomcat.TomcatServer;

public class TomcatEngine
implements Engine {
    protected final TomcatRegistry registry;
    protected final org.apache.catalina.Engine engine;
    protected final Server server;

    public TomcatEngine(TomcatRegistry registry, org.apache.catalina.Engine engine) {
        this.registry = registry;
        this.engine = engine;
        this.server = new TomcatServer(registry, engine.getService().getServer());
    }

    public Server getServer() {
        return this.server;
    }

    public Iterable<Host> getHosts() {
        final Iterator<Container> children = Arrays.asList(this.engine.findChildren()).iterator();
        final Iterator<Host> hosts = new Iterator<Host>(){

            @Override
            public boolean hasNext() {
                return children.hasNext();
            }

            @Override
            public Host next() {
                return new TomcatHost(TomcatEngine.this.registry, (org.apache.catalina.Host)children.next());
            }

            @Override
            public void remove() {
                children.remove();
            }
        };
        return new Iterable<Host>(){

            @Override
            public Iterator<Host> iterator() {
                return hosts;
            }
        };
    }

    public String getDefaultHost() {
        return this.engine.getDefaultHost();
    }

    public String getJvmRoute() {
        return this.engine.getJvmRoute();
    }

    public void setJvmRoute(String jvmRoute) {
        this.engine.setJvmRoute(jvmRoute);
    }

    public String getName() {
        return this.engine.getName();
    }

    public Iterable<Connector> getConnectors() {
        final Iterator<org.apache.catalina.connector.Connector> connectors = Arrays.asList(this.engine.getService().findConnectors()).iterator();
        final Iterator<Connector> iterator = new Iterator<Connector>(){

            @Override
            public boolean hasNext() {
                return connectors.hasNext();
            }

            @Override
            public Connector next() {
                return new TomcatConnector((org.apache.catalina.connector.Connector)connectors.next());
            }

            @Override
            public void remove() {
                connectors.remove();
            }
        };
        return new Iterable<Connector>(){

            @Override
            public Iterator<Connector> iterator() {
                return iterator;
            }
        };
    }

    public Connector getProxyConnector() {
        return this.registry.getProxyConnectorProvider().createProxyConnector(this.engine);
    }

    public Host findHost(String name) {
        org.apache.catalina.Host host = (org.apache.catalina.Host)this.engine.findChild(name);
        return host != null ? new TomcatHost(this.registry, host) : null;
    }

    public String getSessionCookieName() {
        return SessionConfig.getSessionCookieName(null);
    }

    public String getSessionParameterName() {
        return SessionConfig.getSessionUriParamName(null);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TomcatEngine)) {
            return false;
        }
        TomcatEngine engine = (TomcatEngine)object;
        return this.engine == engine.engine;
    }

    public int hashCode() {
        return this.engine.hashCode();
    }

    public String toString() {
        return this.engine.getName();
    }
}

