/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.jbossweb;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.catalina.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.container.catalina.CatalinaFactory;
import org.jboss.modcluster.container.catalina.JMXServerProvider;
import org.jboss.modcluster.container.catalina.ServerProvider;

public class JBossWebEventHandlerAdapter
extends CatalinaEventHandlerAdapter
implements NotificationListener {
    private volatile ObjectName serviceObjectName = JBossWebEventHandlerAdapter.toObjectName((String)"jboss.web:service=WebServer");
    private volatile String connectorsStartedNotificationType = "jboss.tomcat.connectors.started";
    private volatile String connectorsStoppedNotificationType = "jboss.tomcat.connectors.stopped";
    private final MBeanServer mbeanServer;

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler) {
        this(eventHandler, ManagementFactory.getPlatformMBeanServer());
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, MBeanServer mbeanServer) {
        this(eventHandler, mbeanServer, (ServerProvider)new JMXServerProvider(mbeanServer, JBossWebEventHandlerAdapter.toObjectName((String)"jboss.web:type=Server")));
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, Server server) {
        super(eventHandler, server);
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, ServerProvider provider) {
        this(eventHandler, ManagementFactory.getPlatformMBeanServer(), provider);
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, MBeanServer mbeanServer, ServerProvider provider) {
        super(eventHandler, provider);
        this.mbeanServer = mbeanServer;
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, ServerProvider provider, CatalinaFactory factory) {
        this(eventHandler, ManagementFactory.getPlatformMBeanServer(), provider, factory);
    }

    public JBossWebEventHandlerAdapter(ContainerEventHandler eventHandler, MBeanServer mbeanServer, ServerProvider provider, CatalinaFactory factory) {
        super(eventHandler, provider, factory);
        this.mbeanServer = mbeanServer;
    }

    protected void init(Server server) {
        super.init(server);
        if (this.mbeanServer.isRegistered(this.serviceObjectName)) {
            try {
                this.mbeanServer.addNotificationListener(this.serviceObjectName, this, null, (Object)server);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void destroy(Server server) {
        if (this.mbeanServer.isRegistered(this.serviceObjectName)) {
            try {
                this.mbeanServer.removeNotificationListener(this.serviceObjectName, this);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (ListenerNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        super.destroy(server);
    }

    public void handleNotification(Notification notification, Object object) {
        String type = notification.getType();
        if (type != null) {
            if (type.equals(this.connectorsStartedNotificationType)) {
                if (this.start.get()) {
                    for (Service service : ((Server)object).findServices()) {
                        this.eventHandler.status(this.factory.createEngine((Engine)service.getContainer()));
                    }
                }
            } else if (type.equals(this.connectorsStoppedNotificationType) && this.init.get() && this.start.compareAndSet(true, false)) {
                this.eventHandler.stop(this.factory.createServer((Server)object));
            }
        }
    }

    public void setServiceObjectName(ObjectName serviceObjectName) {
        this.serviceObjectName = serviceObjectName;
    }

    public void setConnectorsStoppedNotificationType(String type) {
        this.connectorsStoppedNotificationType = type;
    }

    public void setConnectorsStartedNotificationType(String type) {
        this.connectorsStartedNotificationType = type;
    }

    public int hashCode() {
        return 1;
    }
}

