/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractLazyMetaData;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.plugins.AbstractNamedAliasMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.MutableLifecycleHolder;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.NamedAliasMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.managed.api.annotation.ManagementDeployment;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.xb.annotations.JBossXmlSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementDeployment(types={"jboss-beans"})
@ManagementObject(properties=ManagementProperties.EXPLICIT)
@JBossXmlSchema(namespace="urn:jboss:bean-deployer:2.0", elementFormDefault=XmlNsForm.QUALIFIED, replacePropertyRefs=false)
@XmlRootElement(name="deployment")
@XmlType(name="deploymentType", propOrder={"annotations", "classLoader", "beanFactories", "create", "start", "stop", "destroy", "aliases"})
public class AbstractKernelDeployment
extends JBossObject
implements KernelDeployment,
MutableLifecycleHolder,
Serializable {
    private static final long serialVersionUID = 3L;
    protected String name;
    protected boolean installed;
    protected transient List<KernelControllerContext> installedContexts = new CopyOnWriteArrayList<KernelControllerContext>();
    protected Boolean scoped;
    protected Set<AnnotationMetaData> annotations;
    protected List<BeanMetaDataFactory> beanFactories;
    protected ClassLoaderMetaData classLoader;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;
    protected LifecycleMetaData stop;
    protected LifecycleMetaData destroy;
    protected ControllerMode mode;
    protected Set<NamedAliasMetaData> aliases;

    @Deprecated
    public void setBeans(List beans) {
        this.beanFactories = beans;
        this.flushJBossObjectCache();
    }

    @ManagementProperty(managed=true)
    @XmlElements(value={@XmlElement(name="bean", type=AbstractBeanMetaData.class), @XmlElement(name="beanfactory", type=GenericBeanFactoryMetaData.class), @XmlElement(name="lazy", type=AbstractLazyMetaData.class)})
    @XmlAnyElement
    public void setBeanFactories(List<BeanMetaDataFactory> beanFactories) {
        this.beanFactories = beanFactories;
        this.flushJBossObjectCache();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @XmlAttribute
    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    public void setInstalled(boolean installed) {
        this.installed = installed;
        this.flushJBossObjectCache();
    }

    @Override
    public void addInstalledContext(KernelControllerContext context) {
        this.installedContexts.add(context);
        this.flushJBossObjectCache();
    }

    @Override
    public List<KernelControllerContext> getInstalledContexts() {
        return this.installedContexts;
    }

    @Override
    public void removeInstalledContext(KernelControllerContext context) {
        this.installedContexts.remove(context);
        this.flushJBossObjectCache();
    }

    @Override
    public List<BeanMetaData> getBeans() {
        List<BeanMetaDataFactory> factories;
        ValueMetaData classLoader;
        ArrayList<BeanMetaData> result = new ArrayList<BeanMetaData>();
        ClassLoaderMetaData classLoaderMetaData = this.getClassLoader();
        if (classLoaderMetaData != null && (classLoader = classLoaderMetaData.getClassLoader()) instanceof BeanMetaData) {
            BeanMetaData classLoaderBean = (BeanMetaData)classLoader;
            if (classLoaderBean.getClassLoader() == null) {
                classLoaderBean.setClassLoader(new AbstractClassLoaderMetaData(new AbstractValueMetaData()));
            }
            result.add((BeanMetaData)classLoader);
        }
        if ((factories = this.getBeanFactories()) != null && !factories.isEmpty()) {
            for (BeanMetaDataFactory factory : factories) {
                if (factory == null) {
                    throw new IllegalArgumentException("BeanMetaDataFactory cannot be null.");
                }
                List<BeanMetaData> beans = factory.getBeans();
                if (beans == null || beans.isEmpty()) continue;
                for (BeanMetaData bmd : beans) {
                    ClassLoaderMetaData deploymentClassLoader;
                    ClassLoaderMetaData beanClassLoader;
                    if (bmd == null) {
                        throw new IllegalArgumentException("Bean meta data cannot be null.");
                    }
                    if (this.annotations != null && !this.annotations.isEmpty()) {
                        Set<AnnotationMetaData> annotationsBMD = bmd.getAnnotations();
                        if (annotationsBMD == null) {
                            annotationsBMD = new HashSet<AnnotationMetaData>();
                            bmd.setAnnotations(annotationsBMD);
                        }
                        annotationsBMD.addAll(this.annotations);
                    }
                    if (bmd instanceof AbstractBeanMetaData) {
                        AbstractBeanMetaData bean = (AbstractBeanMetaData)bmd;
                        if (bean.getCreate() == null && this.getCreate() != null) {
                            bean.setCreate(this.getCreate());
                        }
                        if (bean.getStart() == null && this.getStart() != null) {
                            bean.setStart(this.getStart());
                        }
                        if (bean.getStop() == null && this.getStop() != null) {
                            bean.setStop(this.getStop());
                        }
                        if (bean.getDestroy() == null && this.getDestroy() != null) {
                            bean.setDestroy(this.getDestroy());
                        }
                        if (bean.getMode() == null && this.getMode() != null) {
                            bean.setMode(this.getMode());
                        }
                    }
                    if ((beanClassLoader = bmd.getClassLoader()) != null || (deploymentClassLoader = this.getClassLoader()) == null) continue;
                    ValueMetaData classLoader2 = deploymentClassLoader.getClassLoader();
                    if (classLoader2 instanceof BeanMetaData) {
                        classLoader2 = new AbstractDependencyValueMetaData(((BeanMetaData)classLoader2).getName());
                        beanClassLoader = new AbstractClassLoaderMetaData(classLoader2);
                    } else {
                        beanClassLoader = deploymentClassLoader;
                    }
                    bmd.setClassLoader(beanClassLoader);
                }
                result.addAll(beans);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public Boolean getScoped() {
        return this.scoped;
    }

    @XmlAttribute
    public void setScoped(Boolean scoped) {
        this.scoped = scoped;
    }

    @Override
    public Set<AnnotationMetaData> getAnnotations() {
        return this.annotations;
    }

    @XmlElement(name="annotation", type=AbstractAnnotationMetaData.class)
    public void setAnnotations(Set<AnnotationMetaData> annotations) {
        this.annotations = annotations;
    }

    @Override
    public List<BeanMetaDataFactory> getBeanFactories() {
        return this.beanFactories;
    }

    @Override
    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    @XmlElement(name="classloader", type=AbstractClassLoaderMetaData.class)
    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public LifecycleMetaData getCreate() {
        return this.create;
    }

    @Override
    @XmlElement(name="create", type=AbstractLifecycleMetaData.class)
    public void setCreate(LifecycleMetaData create) {
        create.setState(ControllerState.CREATE);
        this.create = create;
    }

    @Override
    public LifecycleMetaData getStart() {
        return this.start;
    }

    @Override
    @XmlElement(name="start", type=AbstractLifecycleMetaData.class)
    public void setStart(LifecycleMetaData start) {
        start.setState(ControllerState.START);
        this.start = start;
    }

    @Override
    public LifecycleMetaData getStop() {
        return this.stop;
    }

    @Override
    @XmlElement(name="stop", type=AbstractLifecycleMetaData.class)
    public void setStop(LifecycleMetaData stop) {
        stop.setState(ControllerState.START);
        this.stop = stop;
    }

    @Override
    public LifecycleMetaData getDestroy() {
        return this.destroy;
    }

    @Override
    @XmlElement(name="destroy", type=AbstractLifecycleMetaData.class)
    public void setDestroy(LifecycleMetaData destroy) {
        destroy.setState(ControllerState.CREATE);
        this.destroy = destroy;
    }

    @Override
    public Set<NamedAliasMetaData> getAliases() {
        return this.aliases;
    }

    @XmlElement(name="alias", type=AbstractNamedAliasMetaData.class)
    public void setAliases(Set<NamedAliasMetaData> aliases) {
        this.aliases = aliases;
    }

    @Override
    public ControllerMode getMode() {
        return this.mode;
    }

    @XmlAttribute
    public void setMode(ControllerMode mode) {
        this.mode = mode;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" installed=").append(this.installed);
        if (this.classLoader != null) {
            buffer.append(" classLoader=").append((Object)this.classLoader);
        }
        if (this.beanFactories != null) {
            buffer.append(" beanFactories=").append(this.beanFactories);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.installedContexts = new CopyOnWriteArrayList<KernelControllerContext>();
    }
}

