/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.ejb.TransactionManagementType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractIdMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessorHelper;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.NamedMethodMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.SecurityIdentityParser;
import org.jboss.metadata.ejb.spec.AbstractEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.AbstractGenericBeanMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.LifecycleCallbackMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleRefMetaDataParser;

public abstract class SessionBeanMetaDataParser<T extends AbstractGenericBeanMetaData>
extends AbstractIdMetaDataParser<T> {
    protected abstract T createSessionBeanMetaData();

    @Override
    public T parse(XMLStreamReader reader) throws XMLStreamException {
        T sessionBean = this.createSessionBeanMetaData();
        AttributeProcessorHelper.processAttributes(sessionBean, reader, this);
        this.processElements(sessionBean, reader);
        return sessionBean;
    }

    @Override
    protected void processElement(T sessionBean, XMLStreamReader reader) throws XMLStreamException {
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
            if (sessionBean.getDescriptionGroup() == null) {
                sessionBean.setDescriptionGroup(descriptionGroup);
            }
            return;
        }
        Environment jndiEnvRefGroup = ((AbstractEnterpriseBeanMetaData)sessionBean).getJndiEnvironmentRefsGroup();
        if (jndiEnvRefGroup == null) {
            jndiEnvRefGroup = new EnvironmentRefsGroupMetaData();
            ((AbstractEnterpriseBeanMetaData)sessionBean).setJndiEnvironmentRefsGroup(jndiEnvRefGroup);
        }
        if (jndiEnvRefGroup instanceof EnvironmentRefsGroupMetaData && EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)((EnvironmentRefsGroupMetaData)jndiEnvRefGroup))) {
            return;
        }
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case EJB_NAME: {
                ((AbstractEnterpriseBeanMetaData)sessionBean).setEjbName(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case MAPPED_NAME: {
                ((AbstractEnterpriseBeanMetaData)sessionBean).setMappedName(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case HOME: {
                ((AbstractGenericBeanMetaData)sessionBean).setHome(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case REMOTE: {
                ((AbstractGenericBeanMetaData)sessionBean).setRemote(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case LOCAL_HOME: {
                ((AbstractGenericBeanMetaData)sessionBean).setLocalHome(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case LOCAL: {
                ((AbstractGenericBeanMetaData)sessionBean).setLocal(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case SERVICE_ENDPOINT: {
                ((AbstractGenericBeanMetaData)sessionBean).setServiceEndpoint(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case EJB_CLASS: {
                ((AbstractEnterpriseBeanMetaData)sessionBean).setEjbClass(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case SESSION_TYPE: {
                SessionType sessionType = this.processSessionType(SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader));
                if (sessionType == null) {
                    throw SessionBeanMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected value: " + (Object)((Object)sessionType) + " for session-type"));
                }
                ((AbstractGenericBeanMetaData)sessionBean).setSessionType(sessionType);
                return;
            }
            case TIMEOUT_METHOD: {
                NamedMethodMetaData timeoutMethod = NamedMethodMetaDataParser.INSTANCE.parse(reader);
                ((AbstractGenericBeanMetaData)sessionBean).setTimeoutMethod(timeoutMethod);
                return;
            }
            case TRANSACTION_TYPE: {
                String txType = SessionBeanMetaDataParser.getElementText((XMLStreamReader)reader);
                if (txType.equals("Bean")) {
                    ((AbstractGenericBeanMetaData)sessionBean).setTransactionType(TransactionManagementType.BEAN);
                } else if (txType.equals("Container")) {
                    ((AbstractGenericBeanMetaData)sessionBean).setTransactionType(TransactionManagementType.CONTAINER);
                } else {
                    throw SessionBeanMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected value: " + txType + " for transaction-type"));
                }
                return;
            }
            case POST_ACTIVATE: {
                LifecycleCallbacksMetaData postActivates = ((AbstractGenericBeanMetaData)sessionBean).getPostActivates();
                if (postActivates == null) {
                    postActivates = new LifecycleCallbacksMetaData();
                    ((AbstractGenericBeanMetaData)sessionBean).setPostActivates(postActivates);
                }
                LifecycleCallbackMetaData postActivate = LifecycleCallbackMetaDataParser.parse((XMLStreamReader)reader);
                postActivates.add((Object)postActivate);
                return;
            }
            case PRE_PASSIVATE: {
                LifecycleCallbacksMetaData prePassivates = ((AbstractGenericBeanMetaData)sessionBean).getPrePassivates();
                if (prePassivates == null) {
                    prePassivates = new LifecycleCallbacksMetaData();
                    ((AbstractGenericBeanMetaData)sessionBean).setPrePassivates(prePassivates);
                }
                LifecycleCallbackMetaData prePassivate = LifecycleCallbackMetaDataParser.parse((XMLStreamReader)reader);
                prePassivates.add((Object)prePassivate);
                return;
            }
            case SECURITY_ROLE_REF: {
                SecurityRoleRefsMetaData securityRoleRefs = ((AbstractEnterpriseBeanMetaData)sessionBean).getSecurityRoleRefs();
                if (securityRoleRefs == null) {
                    securityRoleRefs = new SecurityRoleRefsMetaData();
                    ((AbstractEnterpriseBeanMetaData)sessionBean).setSecurityRoleRefs(securityRoleRefs);
                }
                SecurityRoleRefMetaData securityRoleRef = SecurityRoleRefMetaDataParser.parse((XMLStreamReader)reader);
                securityRoleRefs.add((MappableMetaData)securityRoleRef);
                return;
            }
            case SECURITY_IDENTITY: {
                SecurityIdentityMetaData securityIdentity = SecurityIdentityParser.INSTANCE.parse(reader);
                ((AbstractEnterpriseBeanMetaData)sessionBean).setSecurityIdentity(securityIdentity);
                return;
            }
        }
        throw SessionBeanMetaDataParser.unexpectedElement((XMLStreamReader)reader);
    }

    protected SessionType processSessionType(String sessionType) {
        if (sessionType.equals("Stateless")) {
            return SessionType.Stateless;
        }
        if (sessionType.equals("Stateful")) {
            return SessionType.Stateful;
        }
        return null;
    }
}

