/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt.resolve.entity;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.util.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XIncludeEntityResolver
implements EntityResolver {
    private final Environment environment;

    public XIncludeEntityResolver(Environment environment) {
        this.environment = environment;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (publicId != null || systemId == null) {
            return null;
        }
        if (!systemId.startsWith("file:") && !systemId.endsWith(".xml")) {
            return null;
        }
        File file = new File(new URL(systemId).getFile());
        if (!file.exists()) {
            return null;
        }
        InputSource source = FileUtils.createInputSource(file, this.environment.getValueInjections());
        source.setSystemId(systemId);
        return source;
    }
}

