/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt.resolve.entity;

import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LocalDocBookEntityResolver
implements EntityResolver {
    public static final String SYSTEM_ID_PREFIX = "http://www.oasis-open.org/docbook/xml/";
    public static final int SYSTEM_ID_PREFIX_LEN = "http://www.oasis-open.org/docbook/xml/".length();

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId == null) {
            return null;
        }
        if (systemId.startsWith(SYSTEM_ID_PREFIX)) {
            int versionEndTokenPosition = systemId.indexOf(47, SYSTEM_ID_PREFIX_LEN);
            String version = systemId.substring(SYSTEM_ID_PREFIX_LEN, versionEndTokenPosition);
            String name = systemId.substring(versionEndTokenPosition + 1);
            String resourceName = "docbook/xml/" + version + '/' + name;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                stream = this.getClass().getClassLoader().getResourceAsStream('/' + resourceName);
            }
            if (stream != null) {
                InputSource source = new InputSource(stream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
        }
        return null;
    }
}

