/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.render.PublishingSource;
import org.jboss.jdocbook.render.Renderer;
import org.jboss.jdocbook.render.RenderingEnvironment;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.util.ConsoleRedirectionHandler;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.LocaleUtils;
import org.jboss.jdocbook.xslt.XSLTException;
import org.xml.sax.EntityResolver;

public class BasicRenderer
implements Renderer {
    protected final RenderingEnvironment environment;
    protected final EntityResolver entityResolver;
    protected final FormatPlan formatPlan;

    public BasicRenderer(RenderingEnvironment environment, EntityResolver entityResolver, FormatPlan formatPlan) {
        this.environment = environment;
        this.entityResolver = entityResolver;
        this.formatPlan = formatPlan;
    }

    protected Log getLog() {
        return this.environment.log();
    }

    public void render() throws RenderingException, XSLTException {
        for (PublishingSource source : this.environment.getPublishingSources(true)) {
            boolean created;
            File sourceFile;
            String lang = this.stringify(source.getLocale());
            this.getLog().trace("Starting generation " + lang);
            File file = sourceFile = this.environment.getProfilingConfiguration().isEnabled() ? source.resolveProfiledDocumentFile() : source.resolveDocumentFile();
            if (!sourceFile.exists()) {
                this.getLog().info("Source document [" + sourceFile.getAbsolutePath() + "] did not exist; skipping");
                continue;
            }
            File publishingDirectory = source.resolvePublishingDirectory();
            if (!publishingDirectory.exists() && !(created = publishingDirectory.mkdirs())) {
                this.getLog().info("Unable to create publishing directory {}", publishingDirectory.getAbsolutePath());
            }
            this.getLog().info("Processing " + lang + " -> " + this.formatPlan.getName());
            this.render(sourceFile, this.formatPlan, publishingDirectory, this.environment.getStagingDirectory(), source);
        }
    }

    private String stringify(Locale locale) {
        return LocaleUtils.render(locale, this.environment.getOptions().getLocaleSeparator());
    }

    public void render(File sourceFile, FormatPlan formatPlan, File renderingDirectory, File stagingDirectory, PublishingSource source) throws RenderingException, XSLTException {
        boolean deleted;
        File targetFile;
        File targetDirectory = new File(renderingDirectory, formatPlan.getName());
        if (!targetDirectory.exists()) {
            FileUtils.mkdir((String)targetDirectory.getAbsolutePath());
        }
        if (formatPlan.isImageCopyingRequired() && stagingDirectory.exists()) {
            File cssBase;
            File imageBase = new File(stagingDirectory, "images");
            if (imageBase.exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)imageBase, (File)targetDirectory);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy images", e);
                }
            }
            if ((cssBase = new File(stagingDirectory, "css")).exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)cssBase, (File)targetDirectory);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy css", e);
                }
            }
        }
        if ((targetFile = new File(targetDirectory, this.deduceTargetFileName(sourceFile, formatPlan))).exists() && !(deleted = targetFile.delete())) {
            this.getLog().info("Unable to delete existing target file " + targetFile.getAbsolutePath());
        }
        if (!targetFile.exists()) {
            try {
                boolean created = targetFile.createNewFile();
                if (!created) {
                    this.getLog().info("Unable to create target file [{}]", targetFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RenderingException("unable to create output file [" + targetFile.getAbsolutePath() + "]", e);
            }
        }
        this.performRendering(sourceFile, formatPlan, stagingDirectory, targetFile, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRendering(File sourceFile, FormatPlan formatPlan, File stagingDirectory, File targetFile, PublishingSource source) {
        Transformer transformer = this.buildTransformer(targetFile, formatPlan, stagingDirectory);
        String lang = LocaleUtils.render(source.getLocale(), this.environment.getOptions().getLocaleSeparator());
        transformer.setParameter("l10n.gentext.language", lang);
        ConsoleRedirectionHandler console = new ConsoleRedirectionHandler(this.determineConsoleRedirectFile(source, formatPlan));
        console.start();
        try {
            Source transformationSource = this.buildSource(sourceFile);
            Result transformationResult = this.buildResult(targetFile);
            try {
                transformer.transform(transformationSource, transformationResult);
            }
            catch (TransformerException e) {
                throw new XSLTException("error rendering [" + e.getMessageAndLocation() + "] on " + sourceFile.getName(), e);
            }
            finally {
                this.releaseResult(transformationResult);
            }
        }
        finally {
            console.stop();
        }
    }

    private File determineConsoleRedirectFile(PublishingSource source, FormatPlan formatPlan) {
        String fileName = "console-" + this.stringify(source.getLocale()) + "-" + formatPlan.getName() + ".log";
        return new File(new File(this.environment.getWorkDirectory(), "log"), fileName);
    }

    private String deduceTargetFileName(File source, FormatPlan formatPlan) {
        return formatPlan.getTargetNamingStrategy().determineTargetFileName(source);
    }

    protected Transformer buildTransformer(File targetFile, FormatPlan formatPlan, File stagingDirectory) throws RenderingException, XSLTException {
        URL transformationStylesheet = this.environment.getResourceHelper().requireResource(formatPlan.getStylesheetResource());
        Transformer transformer = this.environment.getTransformerBuilder().buildTransformer(formatPlan, transformationStylesheet);
        if (formatPlan.isImagePathSettingRequired()) {
            try {
                String imgSrcPath = new File(stagingDirectory, "images").toURI().toURL().toString();
                if (!imgSrcPath.endsWith("/")) {
                    imgSrcPath = imgSrcPath + '/';
                }
                this.getLog().trace("setting 'img.src.path' xslt parameter [" + imgSrcPath + "]");
                transformer.setParameter("img.src.path", imgSrcPath);
            }
            catch (MalformedURLException e) {
                throw new XSLTException("unable to prepare 'img.src.path' xslt parameter", e);
            }
        }
        transformer.setParameter("keep.relative.image.uris", this.environment.getOptions().isUseRelativeImageUris() ? "1" : "0");
        transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("manifest.in.base.dir", "1");
        if (formatPlan.isDoingChunking()) {
            String rootFilename = targetFile.getName();
            rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
            transformer.setParameter("root.filename", rootFilename);
        }
        return transformer;
    }

    protected Source buildSource(File sourceFile) throws RenderingException {
        return FileUtils.createSAXSource(sourceFile, this.entityResolver, this.environment.getOptions().isXincludeSupported(), this.environment.getValueInjections());
    }

    protected Result buildResult(File targetFile) throws RenderingException, XSLTException {
        return new StreamResult(targetFile);
    }

    protected void releaseResult(Result transformationResult) {
    }
}

