/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.i18n.I18nEnvironment;
import org.jboss.jdocbook.i18n.PotSynchronizer;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.I18nUtils;
import org.jboss.jdocbook.util.XIncludeHelper;

public class PotSynchronizerImpl
implements PotSynchronizer {
    private I18nEnvironment environment;

    public PotSynchronizerImpl(I18nEnvironment environment) {
        this.environment = environment;
    }

    private Log getLog() {
        return this.environment.log();
    }

    public void synchronizePot() throws JDocBookProcessException {
        this.synchronizePot(this.environment.getMasterTranslationDescriptor().resolveMasterDocument(), this.environment.getMasterTranslationDescriptor().resolvePotDirectory());
    }

    private void synchronizePot(File masterFile, File potDirectory) throws JDocBookProcessException {
        HashSet<File> files = new HashSet<File>();
        XIncludeHelper.findAllInclusionFiles(masterFile, files);
        files.add(masterFile);
        File baseDir = masterFile.getParentFile();
        for (File file : files) {
            File relativeTranslationDir;
            String relativity = FileUtils.determineRelativity(file, baseDir);
            File file2 = relativeTranslationDir = relativity == null ? potDirectory : new File(potDirectory, relativity);
            if (!FileUtils.isXMLFile(file)) continue;
            String poFileName = I18nUtils.determinePotFileName(file);
            File potFile = new File(relativeTranslationDir, poFileName);
            this.updatePortableObjectTemplate(file, potFile);
        }
    }

    private void updatePortableObjectTemplate(File masterFile, File potFile) {
        boolean created;
        if (!masterFile.exists()) {
            this.getLog().trace("skipping POT update; source file did not exist : {0}", masterFile);
            return;
        }
        if (potFile.exists() && potFile.lastModified() >= masterFile.lastModified()) {
            this.getLog().trace("skipping POT update; up-to-date : {0}", potFile);
            return;
        }
        if (!potFile.getParentFile().exists() && !(created = potFile.getParentFile().mkdirs())) {
            this.getLog().info("Unable to generate POT directory {}" + FileUtils.resolveFullPathName(potFile.getParentFile()));
        }
        this.executeXml2pot(masterFile, potFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeXml2pot(File masterFile, File potFile) {
        CommandLine commandLine = CommandLine.parse((String)"xml2pot");
        commandLine.addArgument(FileUtils.resolveFullPathName(masterFile));
        DefaultExecutor executor = new DefaultExecutor();
        try {
            FileOutputStream xmlStream = new FileOutputStream(potFile);
            PumpStreamHandler streamDirector = new PumpStreamHandler((OutputStream)xmlStream, (OutputStream)System.err);
            executor.setStreamHandler((ExecuteStreamHandler)streamDirector);
            try {
                this.getLog().trace("updating POT file {0}", potFile);
                executor.execute(commandLine);
            }
            finally {
                try {
                    xmlStream.flush();
                    xmlStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to open output stream for POT file [" + potFile + "]");
        }
    }
}

