/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.reflect.SerializableField;
import sun.reflect.ReflectionFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ReflectionFactory reflectionFactory = System.getSecurityManager() == null ? ReflectionFactory.getReflectionFactory() : AccessController.doPrivileged(new PrivilegedAction<ReflectionFactory>(){

        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    });

    JDKSpecific() {
    }

    static boolean isRecord(Class<?> type) {
        return type.isRecord();
    }

    static SerializableField.RecordComponent[] getRecordComponents(Class<?> type) {
        RecordComponent[] recordComponents = type.getRecordComponents();
        SerializableField.RecordComponent[] result = new SerializableField.RecordComponent[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            result[i] = new SerializableField.RecordComponent(recordComponents[i].getName(), recordComponents[i].getType(), i);
        }
        return result;
    }

    static Object getRecordComponentValue(Object recordObject, String name, Class<?> type) {
        try {
            MethodHandle methodHandle = MethodHandles.privateLookupIn(recordObject.getClass(), LOOKUP).findVirtual(recordObject.getClass(), name, MethodType.methodType(type));
            return methodHandle.invoke(recordObject);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot invoke record getter " + name + " in object " + String.valueOf(recordObject), e);
        }
    }

    static Object invokeRecordCanonicalConstructor(Class<?> recordType, SerializableField[] fields, Object[] args) {
        try {
            Class[] paramTypes = new Class[fields.length];
            for (SerializableField field : fields) {
                paramTypes[field.getRecordComponentIndex()] = field.getType();
            }
            MethodHandle constructorHandle = MethodHandles.privateLookupIn(recordType, LOOKUP).findConstructor(recordType, MethodType.methodType(Void.TYPE, paramTypes)).asType(MethodType.methodType(Object.class, paramTypes));
            return constructorHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Error calling onstructor on record class " + String.valueOf(recordType), e);
        }
    }

    static Constructor<?> newConstructorForSerialization(Class<?> classToInstantiate, Constructor<?> constructorToCall) {
        return reflectionFactory.newConstructorForSerialization(classToInstantiate, constructorToCall);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class SerMethods {
        private final MethodHandle readObject;
        private final MethodHandle readObjectNoData;
        private final MethodHandle writeObject;
        private final MethodHandle readResolve;
        private final MethodHandle writeReplace;
        private final Constructor<?> noArgConstructor;
        private final Constructor<?> objectInputConstructor;

        SerMethods(Class<?> clazz) {
            Constructor<?> ctor;
            this.readObject = reflectionFactory.readObjectForSerialization(clazz);
            this.readObjectNoData = reflectionFactory.readObjectNoDataForSerialization(clazz);
            this.writeObject = reflectionFactory.writeObjectForSerialization(clazz);
            this.readResolve = reflectionFactory.readResolveForSerialization(clazz);
            this.writeReplace = reflectionFactory.writeReplaceForSerialization(clazz);
            Constructor<?> noArgConstructor = null;
            try {
                ctor = clazz.getDeclaredConstructor(new Class[0]);
                noArgConstructor = reflectionFactory.newConstructorForSerialization(clazz, ctor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.noArgConstructor = noArgConstructor;
            Constructor<?> objectInputConstructor = null;
            try {
                ctor = clazz.getDeclaredConstructor(ObjectInput.class);
                objectInputConstructor = reflectionFactory.newConstructorForSerialization(clazz, ctor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.objectInputConstructor = objectInputConstructor;
        }

        boolean hasWriteObject() {
            return this.writeObject != null;
        }

        void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
            try {
                this.writeObject.invoke(object, outputStream);
            }
            catch (IOException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasReadObject() {
            return this.readObject != null;
        }

        void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            try {
                this.readObject.invoke(object, inputStream);
            }
            catch (IOException | ClassNotFoundException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasReadObjectNoData() {
            return this.readObjectNoData != null;
        }

        void callReadObjectNoData(Object object) throws ObjectStreamException {
            try {
                this.readObjectNoData.invoke(object);
            }
            catch (ObjectStreamException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasWriteReplace() {
            return this.writeReplace != null;
        }

        Object callWriteReplace(Object object) throws ObjectStreamException {
            try {
                return this.writeReplace.invoke(object);
            }
            catch (ObjectStreamException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        boolean hasReadResolve() {
            return this.readResolve != null;
        }

        Object callReadResolve(Object object) throws ObjectStreamException {
            try {
                return this.readResolve.invoke(object);
            }
            catch (ObjectStreamException | Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        Constructor<?> getNoArgConstructor() {
            return this.noArgConstructor;
        }

        Constructor<?> getObjectInputConstructor() {
            return this.objectInputConstructor;
        }
    }
}

