/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.marshalling.UnmarshallingObjectInputFilter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    private static final Logger LOG = Logger.getLogger(JDKSpecific.class.getName());
    private static final Class<?> _ObjectInputFilter;
    private static final Class<?> _FilterInfo;
    private static final Method _serialClass;
    private static final Method _arrayLength;
    private static final Method _depth;
    private static final Method _references;
    private static final Method _streamBytes;
    private static final Method _setObjectInputFilter;
    private static final Object _allowedResult;
    private static final Object _rejectedResult;
    private static final Object _undecidedResult;
    private static final Exception _oifReflectionException;
    private static final Method _getSerialFilter;
    private static final Method _checkInput;
    private static final Exception _fiReflectionException;

    private JDKSpecific() {
    }

    static OptionalDataException createOptionalDataException(int length) {
        OptionalDataException optionalDataException = JDKSpecific.createOptionalDataException();
        optionalDataException.length = length;
        return optionalDataException;
    }

    static OptionalDataException createOptionalDataException(boolean eof) {
        OptionalDataException optionalDataException = JDKSpecific.createOptionalDataException();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement[] copyStackTrace = new StackTraceElement[stackTrace.length - 1];
        System.arraycopy(stackTrace, 1, copyStackTrace, 0, copyStackTrace.length);
        optionalDataException.setStackTrace(copyStackTrace);
        optionalDataException.eof = eof;
        return optionalDataException;
    }

    static OptionalDataException createOptionalDataException() {
        return System.getSecurityManager() == null ? OptionalDataExceptionCreateAction.INSTANCE.run() : AccessController.doPrivileged(OptionalDataExceptionCreateAction.INSTANCE);
    }

    static Class<?> getMyCaller() {
        return Holder.STACK_TRACE_READER.getClassContext()[3];
    }

    static void setObjectInputStreamFilter(ObjectInputStream ois, final UnmarshallingObjectInputFilter delegate) {
        try {
            if (_oifReflectionException != null) {
                throw new IllegalStateException(_oifReflectionException);
            }
            Object objectInputFilterProxy = Proxy.newProxyInstance(null, new Class[]{_ObjectInputFilter}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object status;
                    assert ("checkInput".equals(method.getName()));
                    assert (args.length == 1 && args[0] != null);
                    assert (_FilterInfo.isAssignableFrom(args[0].getClass()));
                    Object filterInfo = args[0];
                    final Class serialClass = (Class)_serialClass.invoke(filterInfo, new Object[0]);
                    final long arrayLength = (Long)_arrayLength.invoke(filterInfo, new Object[0]);
                    final long depth = (Long)_depth.invoke(filterInfo, new Object[0]);
                    final long references = (Long)_references.invoke(filterInfo, new Object[0]);
                    final long streamBytes = (Long)_streamBytes.invoke(filterInfo, new Object[0]);
                    UnmarshallingObjectInputFilter.Status response = delegate.checkInput(new UnmarshallingObjectInputFilter.FilterInfo(){

                        @Override
                        public Class<?> getUnmarshalledClass() {
                            return serialClass;
                        }

                        @Override
                        public long getArrayLength() {
                            return arrayLength;
                        }

                        @Override
                        public long getDepth() {
                            return depth;
                        }

                        @Override
                        public long getReferences() {
                            return references;
                        }

                        @Override
                        public long getStreamBytes() {
                            return streamBytes;
                        }
                    });
                    switch (response) {
                        case ALLOWED: {
                            status = _allowedResult;
                            break;
                        }
                        case REJECTED: {
                            status = _rejectedResult;
                            break;
                        }
                        case UNDECIDED: {
                            status = _undecidedResult;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected unmarshalling filter result: " + (Object)((Object)response));
                        }
                    }
                    if (status instanceof Exception) {
                        throw (Exception)status;
                    }
                    return status;
                }
            });
            if (delegate != null) {
                _setObjectInputFilter.invoke(null, ois, objectInputFilterProxy);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e, () -> "Unmarshaller failed to set ObjectInputFilter to underlying ObjectInputStream.");
        }
    }

    static UnmarshallingObjectInputFilter getJEPS290ProcessWideFilter() {
        try {
            if (_fiReflectionException != null) {
                throw new IllegalStateException(_fiReflectionException);
            }
            final Object serialFilter = _getSerialFilter.invoke(null, new Object[0]);
            if (serialFilter == null) {
                return null;
            }
            return new UnmarshallingObjectInputFilter(){

                @Override
                public UnmarshallingObjectInputFilter.Status checkInput(final UnmarshallingObjectInputFilter.FilterInfo input) {
                    Object filterInfo = Proxy.newProxyInstance(null, new Class[]{_FilterInfo}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) {
                            assert (args == null || args.length == 0);
                            switch (method.getName()) {
                                case "serialClass": {
                                    return input.getUnmarshalledClass();
                                }
                                case "arrayLength": {
                                    return input.getArrayLength();
                                }
                                case "depth": {
                                    return input.getDepth();
                                }
                                case "references": {
                                    return input.getReferences();
                                }
                                case "streamBytes": {
                                    return input.getStreamBytes();
                                }
                            }
                            throw new IllegalStateException("Unknown method " + method.getName());
                        }
                    });
                    try {
                        Enum status = (Enum)_checkInput.invoke(serialFilter, filterInfo);
                        switch (status.name()) {
                            case "ALLOWED": {
                                return UnmarshallingObjectInputFilter.Status.ALLOWED;
                            }
                            case "REJECTED": {
                                return UnmarshallingObjectInputFilter.Status.REJECTED;
                            }
                            case "UNDECIDED": {
                                return UnmarshallingObjectInputFilter.Status.UNDECIDED;
                            }
                        }
                        throw new IllegalStateException("Unexpected filtering decision: " + status);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to build adapter for the static JVM-wide deserialization filter.", e);
            return null;
        }
    }

    static {
        Exception oifReflectionException = null;
        Exception fiReflectionException = null;
        Class<?> objectInputFilter = null;
        Class<?> filterInfo = null;
        Method serialClass = null;
        Method arrayLength = null;
        Method depth = null;
        Method references = null;
        Method streamBytes = null;
        Method setObjectInputFilter = null;
        Method getSerialFilter = null;
        Method checkInput = null;
        Enum allowedResult = null;
        Enum rejectedResult = null;
        Enum undecidedResult = null;
        try {
            objectInputFilter = Class.forName("sun.misc.ObjectInputFilter");
            Class<?> config = Class.forName("sun.misc.ObjectInputFilter$Config");
            try {
                filterInfo = Class.forName("sun.misc.ObjectInputFilter$FilterInfo");
                Class<?> status = Class.forName("sun.misc.ObjectInputFilter$Status");
                serialClass = filterInfo.getMethod("serialClass", new Class[0]);
                arrayLength = filterInfo.getMethod("arrayLength", new Class[0]);
                depth = filterInfo.getMethod("depth", new Class[0]);
                references = filterInfo.getMethod("references", new Class[0]);
                streamBytes = filterInfo.getMethod("streamBytes", new Class[0]);
                setObjectInputFilter = config.getMethod("setObjectInputFilter", ObjectInputStream.class, objectInputFilter);
                Map<String, Enum> statusMap = Arrays.stream((Enum[])status.getEnumConstants()).collect(Collectors.toMap(Enum::name, c -> c));
                Function<String, Enum> absentExceptionSupplier = name -> {
                    throw new IllegalStateException(String.format("Failed to map FilterResponse %s to ObjectInputFilter.Status", name));
                };
                allowedResult = statusMap.computeIfAbsent("ALLOWED", absentExceptionSupplier);
                rejectedResult = statusMap.computeIfAbsent("REJECTED", absentExceptionSupplier);
                undecidedResult = statusMap.computeIfAbsent("UNDECIDED", absentExceptionSupplier);
            }
            catch (Exception e) {
                oifReflectionException = e;
            }
            try {
                getSerialFilter = config.getMethod("getSerialFilter", new Class[0]);
                checkInput = objectInputFilter.getMethod("checkInput", filterInfo);
            }
            catch (Exception e) {
                fiReflectionException = e;
            }
        }
        catch (Exception e) {
            oifReflectionException = e;
            fiReflectionException = e;
        }
        _ObjectInputFilter = objectInputFilter;
        _FilterInfo = filterInfo;
        _serialClass = serialClass;
        _arrayLength = arrayLength;
        _depth = depth;
        _references = references;
        _streamBytes = streamBytes;
        _setObjectInputFilter = setObjectInputFilter;
        _getSerialFilter = getSerialFilter;
        _checkInput = checkInput;
        _oifReflectionException = oifReflectionException;
        _allowedResult = allowedResult;
        _rejectedResult = rejectedResult;
        _undecidedResult = undecidedResult;
        _fiReflectionException = fiReflectionException;
    }

    static final class OptionalDataExceptionCreateAction
    implements PrivilegedAction<OptionalDataException> {
        static final OptionalDataExceptionCreateAction INSTANCE = new OptionalDataExceptionCreateAction();
        private final Constructor<OptionalDataException> constructor;

        OptionalDataExceptionCreateAction() {
            if (System.getSecurityManager() == null) {
                try {
                    this.constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
                    this.constructor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodError(e.getMessage());
                }
            } else {
                this.constructor = AccessController.doPrivileged(new PrivilegedAction<Constructor<OptionalDataException>>(){

                    @Override
                    public Constructor<OptionalDataException> run() {
                        try {
                            Constructor<OptionalDataException> constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
                            constructor.setAccessible(true);
                            return constructor;
                        }
                        catch (NoSuchMethodException e) {
                            throw new NoSuchMethodError(e.getMessage());
                        }
                    }
                });
            }
        }

        @Override
        public OptionalDataException run() {
            try {
                return this.constructor.newInstance(Boolean.FALSE);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error invoking constructor", e);
            }
        }
    }

    static final class Holder {
        static final StackTraceReader STACK_TRACE_READER = System.getSecurityManager() == null ? new StackTraceReader() : AccessController.doPrivileged(new PrivilegedAction<StackTraceReader>(){

            @Override
            public StackTraceReader run() {
                return new StackTraceReader();
            }
        });

        private Holder() {
        }

        static final class StackTraceReader
        extends SecurityManager {
            StackTraceReader() {
            }

            protected Class[] getClassContext() {
                return super.getClassContext();
            }
        }
    }
}

