/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ByteOutputStream;

public class LimitedByteOutput
extends ByteOutputStream {
    private final long limit;
    private long count;

    public LimitedByteOutput(ByteOutput byteOutput, long limit) {
        super(byteOutput);
        this.limit = limit;
    }

    @Override
    public void write(int b) throws IOException {
        long count = this.count;
        if (count >= this.limit) {
            throw new IOException("Limit exceeded");
        }
        super.write(b);
        this.count = count + 1L;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long count = this.count;
        if (count + (long)len > this.limit) {
            throw new IOException("Limit exceeded");
        }
        try {
            super.write(b, off, len);
        }
        catch (InterruptedIOException e) {
            this.count = count + (long)e.bytesTransferred;
            throw e;
        }
        this.count = count + (long)len;
    }
}

