/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.reflect.ReflectiveCreator;
import sun.reflect.ReflectionFactory;

public class SunReflectiveCreator
extends ReflectiveCreator {
    private static final ReflectionFactory reflectionFactory = AccessController.doPrivileged(new PrivilegedAction<ReflectionFactory>(){

        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    });

    @Override
    protected <T> Constructor<T> getNewConstructor(final Class<T> clazz) {
        Constructor<T> constructor = super.getNewConstructor(clazz);
        if (constructor != null) {
            return constructor;
        }
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                Constructor topConstructor;
                Class current = clazz;
                while (Serializable.class.isAssignableFrom(current)) {
                    current = current.getSuperclass();
                }
                try {
                    topConstructor = current.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
                topConstructor.setAccessible(true);
                Constructor<?> generatedConstructor = reflectionFactory.newConstructorForSerialization(clazz, topConstructor);
                generatedConstructor.setAccessible(true);
                return generatedConstructor;
            }
        });
    }
}

