/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.serial.SerialMarshaller;
import org.jboss.marshalling.serial.SerialUnmarshaller;

public final class SerialMarshallerFactory
extends AbstractMarshallerFactory
implements MarshallerFactory {
    private final SerializableClassRegistry registry = System.getSecurityManager() == null ? SerializableClassRegistry.getInstance() : AccessController.doPrivileged(new PrivilegedAction<SerializableClassRegistry>(){

        @Override
        public SerializableClassRegistry run() {
            return SerializableClassRegistry.getInstance();
        }
    });
    private static final StreamHeader defaultHeader = Marshalling.streamHeader((byte[])new byte[]{-84, -19});

    protected StreamHeader getDefaultStreamHeader() {
        return defaultHeader;
    }

    protected int getDefaultVersion() {
        return 5;
    }

    public Unmarshaller createUnmarshaller(MarshallingConfiguration configuration) throws IOException {
        return new SerialUnmarshaller(this, this.registry, configuration);
    }

    public Marshaller createMarshaller(MarshallingConfiguration configuration) throws IOException {
        return new SerialMarshaller(this, this.registry, configuration);
    }
}

