/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.marshalling.Externalizer;

public final class ExternalizedObject
implements Externalizable {
    private static final long serialVersionUID = -7764783599281227099L;
    private Externalizer externalizer;
    private transient Object obj;

    public ExternalizedObject() {
    }

    public ExternalizedObject(Externalizer externalizer, Object obj) {
        this.externalizer = externalizer;
        this.obj = obj;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.obj.getClass());
        out.writeObject(this.externalizer);
        this.externalizer.writeExternal(this.obj, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o;
        Class subject = (Class)in.readObject();
        this.externalizer = (Externalizer)in.readObject();
        this.obj = o = this.externalizer.createExternal(subject, in);
    }

    protected Object readResolve() {
        return this.obj;
    }

    public <T> T create(Class<T> clazz) throws InvalidClassException {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            InvalidClassException ee = new InvalidClassException(clazz.getName(), e.getMessage());
            ee.initCause(e);
            throw ee;
        }
    }
}

