/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;

public final class ThreadLocalLogContextSelector
implements LogContextSelector {
    private final Object securityKey;
    private final LogContextSelector delegate;
    private final ThreadLocal<LogContext> context = new ThreadLocal();

    public ThreadLocalLogContextSelector(LogContextSelector delegate) {
        this(null, delegate);
    }

    public ThreadLocalLogContextSelector(Object securityKey, LogContextSelector delegate) {
        this.securityKey = securityKey;
        this.delegate = delegate;
    }

    @Override
    public LogContext getLogContext() {
        LogContext localContext = this.context.get();
        return localContext != null ? localContext : this.delegate.getLogContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogContext getAndSet(Object securityKey, LogContext newValue) {
        if (this.securityKey != null && securityKey != this.securityKey) {
            throw new SecurityException("Invalid security key for ThreadLocalLogContextSelector modification");
        }
        try {
            LogContext logContext = this.context.get();
            return logContext;
        }
        finally {
            if (newValue == null) {
                this.context.remove();
            } else {
                this.context.set(newValue);
            }
        }
    }
}

