/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.logging.LogRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;

class JBossLog
implements Log,
Serializable {
    private static final long serialVersionUID = 7757100415375072992L;
    private static final String LOGGER_CLASS_NAME = JBossLog.class.getName();
    private final String name;
    private final transient Logger delegate;

    JBossLog(Logger delegate) {
        this.delegate = delegate;
        this.name = delegate.getName();
    }

    @Override
    public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.FATAL, message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isLoggable((java.util.logging.Level)Level.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isLoggable((java.util.logging.Level)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.delegate.isLoggable((java.util.logging.Level)Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isLoggable((java.util.logging.Level)Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isLoggable((java.util.logging.Level)Level.TRACE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isLoggable((java.util.logging.Level)Level.WARN);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.TRACE, message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Level.TRACE, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t) {
        String msg = String.valueOf(message);
        ExtLogRecord record = new ExtLogRecord((java.util.logging.Level)level, msg, LOGGER_CLASS_NAME);
        record.setThrown(t);
        this.delegate.log((LogRecord)record);
    }

    private Object readResolve() throws ObjectStreamException {
        return LogFactory.getLog(this.name);
    }
}

