/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.jboss.logging.processor.apt.AbstractClassType;
import org.jboss.logging.processor.apt.MessageMethodBuilder;
import org.jboss.logging.processor.apt.ProcessingException;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Objects;

public final class MessageInterfaceFactory {
    private static final Object LOCK = new Object();
    private static volatile LoggerInterface LOGGER_INTERFACE;

    private MessageInterfaceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageInterface of(ProcessingEnvironment processingEnv, TypeElement interfaceElement, Properties expressionProperties, boolean addGeneratedAnnotation) {
        Types types = processingEnv.getTypeUtils();
        if (types.isSameType(interfaceElement.asType(), ElementHelper.toType(processingEnv.getElementUtils(), BasicLogger.class))) {
            LoggerInterface result = LOGGER_INTERFACE;
            if (result == null) {
                Object object = LOCK;
                synchronized (object) {
                    result = LOGGER_INTERFACE;
                    if (result == null) {
                        result = LOGGER_INTERFACE = LoggerInterface.of(processingEnv);
                    }
                }
            }
            return result;
        }
        AptMessageInterface result = new AptMessageInterface(interfaceElement, processingEnv, expressionProperties, addGeneratedAnnotation);
        result.init();
        for (TypeMirror typeMirror : interfaceElement.getInterfaces()) {
            MessageInterface extended = MessageInterfaceFactory.of(processingEnv, (TypeElement)types.asElement(typeMirror), expressionProperties, addGeneratedAnnotation);
            result.extendedInterfaces.add(extended);
            result.extendedInterfaces.addAll(extended.extendedInterfaces());
        }
        return result;
    }

    private static Collection<ExecutableElement> getMessageMethods(TypeElement intf) {
        return ElementFilter.methodsIn(intf.getEnclosedElements()).stream().filter(method -> !method.isDefault() && !method.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
    }

    private static class LoggerInterface
    extends AbstractClassType
    implements MessageInterface {
        private final TypeElement loggerInterface;
        private final Set<MessageMethod> messageMethods = new LinkedHashSet<MessageMethod>();

        private LoggerInterface(ProcessingEnvironment processingEnv, TypeElement loggerInterface) {
            super(processingEnv, loggerInterface.asType());
            this.loggerInterface = loggerInterface;
        }

        private void init() {
            MessageMethodBuilder builder = MessageMethodBuilder.create(this.processingEnv).add(MessageInterfaceFactory.getMessageMethods(this.loggerInterface));
            Set<MessageMethod> m = builder.build();
            this.messageMethods.addAll(m);
        }

        static LoggerInterface of(ProcessingEnvironment processingEnv) {
            LoggerInterface result = new LoggerInterface(processingEnv, ElementHelper.toTypeElement(processingEnv, BasicLogger.class));
            result.init();
            return result;
        }

        @Override
        public boolean extendsLoggerInterface() {
            return false;
        }

        @Override
        public Set<MessageInterface> extendedInterfaces() {
            return Collections.emptySet();
        }

        @Override
        public Collection<MessageMethod> methods() {
            return this.messageMethods;
        }

        @Override
        public String projectCode() {
            return null;
        }

        @Override
        public String name() {
            return BasicLogger.class.getName();
        }

        @Override
        public String packageName() {
            return BasicLogger.class.getPackage().getName();
        }

        @Override
        public String simpleName() {
            return BasicLogger.class.getSimpleName();
        }

        @Override
        public String loggingFQCN() {
            return null;
        }

        @Override
        public List<ValidIdRange> validIdRanges() {
            return Collections.emptyList();
        }

        @Override
        public int getIdLength() {
            return -1;
        }

        @Override
        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.name()).toHashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageInterface)) {
                return false;
            }
            AptMessageInterface other = (AptMessageInterface)obj;
            return org.jboss.logging.processor.util.Objects.areEqual(this.name(), other.name());
        }

        @Override
        public int compareTo(MessageInterface o) {
            return this.name().compareTo(o.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add(this.name()).toString();
        }

        @Override
        public String getComment() {
            return this.elements.getDocComment(this.loggerInterface);
        }

        @Override
        public TypeElement getDelegate() {
            return this.loggerInterface;
        }
    }

    private static class AptMessageInterface
    extends AbstractClassType
    implements MessageInterface {
        private final TypeElement interfaceElement;
        private final Set<MessageInterface> extendedInterfaces;
        private final List<MessageMethod> messageMethods;
        private final List<ValidIdRange> validIdRanges;
        private final Properties expressionProperties;
        private final TypeElement generatedAnnotation;
        private String projectCode;
        private String packageName;
        private String simpleName;
        private String qualifiedName;
        private String fqcn;
        private int idLen;

        private AptMessageInterface(TypeElement interfaceElement, ProcessingEnvironment processingEnv, Properties expressionProperties, boolean addGeneratedAnnotation) {
            super(processingEnv, interfaceElement);
            this.interfaceElement = interfaceElement;
            this.expressionProperties = expressionProperties;
            this.messageMethods = new LinkedList<MessageMethod>();
            this.extendedInterfaces = new LinkedHashSet<MessageInterface>();
            this.validIdRanges = ElementHelper.isAnnotatedWith(interfaceElement, ValidIdRanges.class) ? Arrays.asList(interfaceElement.getAnnotation(ValidIdRanges.class).value()) : (ElementHelper.isAnnotatedWith(interfaceElement, ValidIdRange.class) ? Collections.singletonList(interfaceElement.getAnnotation(ValidIdRange.class)) : Collections.emptyList());
            if (addGeneratedAnnotation) {
                ModuleElement moduleElement = processingEnv.getElementUtils().getModuleElement(Generated.class.getModule().getName());
                this.generatedAnnotation = processingEnv.getElementUtils().getTypeElement(moduleElement, Generated.class.getName());
            } else {
                this.generatedAnnotation = null;
            }
        }

        @Override
        public boolean extendsLoggerInterface() {
            return LOGGER_INTERFACE != null && this.extendedInterfaces.contains(LOGGER_INTERFACE);
        }

        @Override
        public String name() {
            return this.qualifiedName;
        }

        @Override
        public Set<MessageInterface> extendedInterfaces() {
            return Collections.unmodifiableSet(this.extendedInterfaces);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.qualifiedName);
        }

        @Override
        public Collection<MessageMethod> methods() {
            return this.messageMethods;
        }

        @Override
        public int compareTo(MessageInterface o) {
            return this.name().compareTo(o.name());
        }

        @Override
        public String projectCode() {
            return this.projectCode;
        }

        private void init() {
            String value;
            MessageMethodBuilder builder = MessageMethodBuilder.create(this.processingEnv, this.expressionProperties).add(MessageInterfaceFactory.getMessageMethods(this.interfaceElement));
            Set<MessageMethod> m = builder.build();
            this.messageMethods.addAll(m);
            MessageBundle messageBundle = this.interfaceElement.getAnnotation(MessageBundle.class);
            MessageLogger messageLogger = this.interfaceElement.getAnnotation(MessageLogger.class);
            if (messageBundle != null) {
                this.projectCode = messageBundle.projectCode();
                this.idLen = messageBundle.length();
            } else if (messageLogger != null) {
                this.projectCode = messageLogger.projectCode();
                this.idLen = messageLogger.length();
            } else {
                throw new ProcessingException(this.interfaceElement, "Interface is not annotated with @MessageBundle or @MessageLogger");
            }
            this.qualifiedName = this.elements.getBinaryName(this.interfaceElement).toString();
            int lastDot = this.qualifiedName.lastIndexOf(".");
            if (lastDot > 0) {
                this.packageName = this.qualifiedName.substring(0, lastDot);
                this.simpleName = this.qualifiedName.substring(lastDot + 1);
            } else {
                this.packageName = null;
                this.simpleName = this.qualifiedName;
            }
            TypeElement loggingClass = ElementHelper.getClassAnnotationValue(this.interfaceElement, MessageLogger.class, "loggingClass");
            if (loggingClass != null && !(value = loggingClass.getQualifiedName().toString()).equals(Void.class.getName())) {
                this.fqcn = value;
            }
        }

        @Override
        public String packageName() {
            return this.packageName;
        }

        @Override
        public String getComment() {
            return this.elements.getDocComment(this.interfaceElement);
        }

        @Override
        public String simpleName() {
            return this.simpleName;
        }

        @Override
        public String loggingFQCN() {
            return this.fqcn;
        }

        @Override
        public List<ValidIdRange> validIdRanges() {
            return this.validIdRanges;
        }

        @Override
        public int getIdLength() {
            return this.idLen;
        }

        @Override
        public TypeElement getDelegate() {
            return this.interfaceElement;
        }

        @Override
        public TypeElement generatedAnnotation() {
            return this.generatedAnnotation;
        }

        @Override
        public Properties expressionProperties() {
            return this.expressionProperties;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptMessageInterface)) {
                return false;
            }
            AptMessageInterface other = (AptMessageInterface)obj;
            return org.jboss.logging.processor.util.Objects.areEqual(this.name(), other.name());
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add(this.qualifiedName).toString();
        }
    }
}

