/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.ConstructType;
import org.jboss.logging.annotations.LoggingClass;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Signature;
import org.jboss.logging.annotations.Suppressed;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ReturnType;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.validation.FormatValidator;
import org.jboss.logging.processor.validation.FormatValidatorFactory;
import org.jboss.logging.processor.validation.IdLengthValidator;
import org.jboss.logging.processor.validation.IdRangeValidator;
import org.jboss.logging.processor.validation.MessageIdValidator;
import org.jboss.logging.processor.validation.PropertyValidator;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.ValidationMessageFactory;

public final class Validator {
    private static final Collection<String> AVAILABLE_LANGUAGES = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
    private final MessageIdValidator messageIdValidator = new MessageIdValidator();
    private final IdLengthValidator idLengthValidator = new IdLengthValidator();
    private final IdRangeValidator idRangeValidator = new IdRangeValidator();
    private final ProcessingEnvironment processingEnv;
    private final Elements elements;
    private final Types types;

    public Validator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
    }

    public final Collection<ValidationMessage> validate(MessageInterface messageInterface) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String locale = null;
        if (ElementHelper.isAnnotatedWith(messageInterface, MessageBundle.class)) {
            Set<MessageMethod> messageMethods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(messageInterface, messageMethods));
            messages.addAll(this.validateBundle(messageMethods));
            locale = messageInterface.getAnnotation(MessageBundle.class).rootLocale();
        } else if (ElementHelper.isAnnotatedWith(messageInterface, MessageLogger.class)) {
            Set<MessageMethod> messageMethods = this.getAllMethods(messageInterface);
            messages.addAll(this.validateCommon(messageInterface, messageMethods));
            messages.addAll(this.validateLogger(messageMethods));
            locale = messageInterface.getAnnotation(MessageLogger.class).rootLocale();
        } else {
            messages.add(ValidationMessageFactory.createError((Element)messageInterface, "Message interface %s is not a message bundle or message logger.", messageInterface.name()));
        }
        if (locale != null && !locale.isEmpty() && !AVAILABLE_LANGUAGES.contains(Locale.forLanguageTag(locale).getLanguage())) {
            messages.add(ValidationMessageFactory.createWarning(messageInterface, "The locale '%s' may be invalid. The target runtime must include this locale to ensure formatting is handled correctly.", locale));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateCommon(MessageInterface messageInterface, Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap<String, MessageMethod> methodNames = new HashMap<String, MessageMethod>();
        messages.addAll(this.idLengthValidator.validate(messageInterface));
        messages.addAll(this.idRangeValidator.validate(messageInterface));
        for (MessageMethod messageMethod : messageMethods) {
            FormatValidator formatValidator;
            for (ThrowableType throwableType : messageMethod.thrownTypes()) {
                if (!throwableType.isChecked()) continue;
                messages.add(ValidationMessageFactory.createError(messageMethod, "Interface message methods cannot throw checked exceptions."));
            }
            MessageMethod.Message message = messageMethod.message();
            if (message == null) {
                messages.add(ValidationMessageFactory.createError(messageMethod, "All message bundles and message logger message methods must have or inherit a message."));
                continue;
            }
            if (message.hasId()) {
                if (message.id() < 0) {
                    messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Message id %d is invalid. Must be greater than 0 or inherit another valid id.", message.id()));
                } else {
                    messages.addAll(this.messageIdValidator.validate(messageInterface, messageMethod));
                }
            }
            if ((formatValidator = FormatValidatorFactory.create(messageMethod)).isValid()) {
                int paramCount = messageMethod.formatParameterCount();
                if (messageMethod.formatParameterCount() != formatValidator.argumentCount()) {
                    messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Parameter count does not match for format '%s'. Required: %d Provided: %d", formatValidator.format(), formatValidator.argumentCount(), paramCount));
                }
                TreeMap<Integer, Parameter> positions = new TreeMap<Integer, Parameter>();
                boolean validatePositions = false;
                for (Parameter parameter : messageMethod.parameters()) {
                    if (parameter.isAnnotatedWith(Transform.class)) {
                        this.validateTransform(messages, parameter, parameter.getAnnotation(Transform.class));
                    }
                    if (parameter.isAnnotatedWith(Pos.class)) {
                        validatePositions = true;
                        Pos pos = parameter.getAnnotation(Pos.class);
                        Transform[] transforms = pos.transform();
                        if (transforms != null && transforms.length > 0) {
                            if (pos.value().length != transforms.length) {
                                messages.add(ValidationMessageFactory.createError(parameter, "Positional parameters with transforms must have an equal number of positions and transforms."));
                            } else {
                                for (Transform transform : transforms) {
                                    this.validateTransform(messages, parameter, transform);
                                }
                            }
                        }
                        HashSet<Integer> usedPositions = new HashSet<Integer>();
                        for (int position : pos.value()) {
                            if (usedPositions.contains(position)) {
                                messages.add(ValidationMessageFactory.createError((Element)parameter, "Position '%d' already used for this parameter.", position));
                            } else {
                                usedPositions.add(position);
                            }
                            if (positions.containsKey(position)) {
                                messages.add(ValidationMessageFactory.createError((Element)parameter, "Position '%d' already defined on parameter '%s'", position, ((Parameter)positions.get(position)).name()));
                                continue;
                            }
                            positions.put(position, parameter);
                        }
                    }
                    if (!parameter.isAnnotatedWith(Suppressed.class)) continue;
                    if (!messageMethod.returnType().isThrowable()) {
                        messages.add(ValidationMessageFactory.createError(messageMethod, "The @Suppressed parameter annotation can only be used with message bundle methods that return an exception."));
                    }
                    if (this.isTypeAssignableFrom(parameter, Throwable.class)) continue;
                    messages.add(ValidationMessageFactory.createError(parameter, "The parameter annotated with @Suppressed must be assignable to a Throwable type."));
                }
                if (validatePositions) {
                    for (int i = 0; i < messageMethod.formatParameterCount(); ++i) {
                        int positionIndex = i + 1;
                        if (positions.containsKey(positionIndex)) continue;
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Missing parameter with position '%d' defined.", positionIndex));
                    }
                }
            } else {
                messages.add(ValidationMessageFactory.createError(messageMethod, formatValidator.summaryMessage()));
            }
            if (!messageMethod.inheritsMessage()) {
                String key = messageMethod.name() + messageMethod.formatParameterCount();
                if (methodNames.containsKey(key)) {
                    MessageMethod previousMethod = (MessageMethod)methodNames.get(key);
                    messages.add(ValidationMessageFactory.createError(previousMethod, "Only one message with the same format parameters is allowed."));
                    messages.add(ValidationMessageFactory.createError(messageMethod, "Only one message with the same format parameters is allowed."));
                } else {
                    methodNames.put(key, messageMethod);
                }
            }
            messages.addAll(this.validateParameters(messageMethod));
            messages.addAll(PropertyValidator.validate(this.processingEnv, messageMethod));
        }
        return messages;
    }

    private void validateTransform(List<ValidationMessage> messages, Parameter parameter, Transform transform) {
        List<Transform.TransformType> transformTypes = Arrays.asList(transform.value());
        if (parameter.isPrimitive()) {
            messages.add(ValidationMessageFactory.createError(parameter, "Parameters annotated with @Transform cannot be primitives."));
        } else if (transformTypes.contains(Transform.TransformType.GET_CLASS) && transformTypes.contains(Transform.TransformType.SIZE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", Transform.TransformType.GET_CLASS, Transform.TransformType.SIZE));
        } else if (transformTypes.contains(Transform.TransformType.HASH_CODE) && transformTypes.contains(Transform.TransformType.SIZE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", Transform.TransformType.HASH_CODE, Transform.TransformType.SIZE));
        } else if (transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE) && transformTypes.contains(Transform.TransformType.SIZE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", Transform.TransformType.IDENTITY_HASH_CODE, Transform.TransformType.SIZE));
        } else if (transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE) && transformTypes.contains(Transform.TransformType.HASH_CODE)) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Transform type '%s' not allowed with type '%s'", Transform.TransformType.IDENTITY_HASH_CODE, Transform.TransformType.HASH_CODE));
        } else if (!(!transformTypes.contains(Transform.TransformType.SIZE) || parameter.isArray() || parameter.isVarArgs() || parameter.isSubtypeOf(Map.class) || parameter.isSubtypeOf(Collection.class) || parameter.isSubtypeOf(CharSequence.class))) {
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Invalid type (%s) for %s. Must be an array, %s, %s or %s.", parameter.asType(), Transform.TransformType.SIZE, Collection.class.getName(), Map.class.getName(), CharSequence.class.getName()));
        }
    }

    private Collection<ValidationMessage> validateParameters(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        boolean foundCause = false;
        for (Parameter parameter : messageMethod.parameters()) {
            if (parameter.isAnnotatedWith(Cause.class)) {
                if (foundCause) {
                    messages.add(ValidationMessageFactory.createError(messageMethod, "Only one cause parameter is allowed."));
                } else {
                    foundCause = true;
                }
            }
            if (!parameter.isAnnotatedWith(LoggingClass.class) || parameter.isSameAs(Class.class)) continue;
            messages.add(ValidationMessageFactory.createError((Element)parameter, "Parameter %s annotated with @LoggingClass on method %s must be of type %s.", parameter.name(), messageMethod.name(), Class.class.getName()));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundle(Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (MessageMethod messageMethod : messageMethods) {
            messages.addAll(this.validateBundleMethod(messageMethod));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateBundleMethod(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ReturnType returnType = messageMethod.returnType();
        if (returnType.asType().getKind() == TypeKind.VOID || returnType.isPrimitive()) {
            messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Message bundle messageMethod %s has an invalid return type. Cannot be void or a primitive.", messageMethod.name()));
        } else if (returnType.isThrowable()) {
            ThrowableType throwableReturnType = returnType.throwableReturnType();
            if (throwableReturnType.useConstructionParameters()) {
                Signature signature = messageMethod.getAnnotation(Signature.class);
                if (signature != null) {
                    int messageIndex;
                    List<TypeMirror> args = ElementHelper.getClassArrayAnnotationValue(messageMethod, Signature.class, "value");
                    if (!ElementHelper.hasConstructor(this.types, returnType, args)) {
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Could not find constructor for %s with arguments %s", messageMethod.asType(), args));
                    }
                    if ((messageIndex = signature.messageIndex()) < 0) {
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "A messageIndex of 0 or greater is required. Value %d is invalid.", messageIndex));
                    }
                }
                if (ElementHelper.isAnnotatedWith(messageMethod, ConstructType.class)) {
                    TypeElement constructTypeValue = ElementHelper.getClassAnnotationValue(messageMethod, ConstructType.class);
                    if (constructTypeValue == null) {
                        messages.add(ValidationMessageFactory.createError(messageMethod, "Class not defined for the ConstructType"));
                    } else if (!this.types.isAssignable(constructTypeValue.asType(), returnType.asType())) {
                        messages.add(ValidationMessageFactory.createError((Element)messageMethod, "The requested type %s can not be assigned to %s.", constructTypeValue.asType(), returnType.asType()));
                    }
                }
            } else if (!throwableReturnType.useConstructionParameters() && !messageMethod.parametersAnnotatedWith(Param.class).isEmpty()) {
                messages.add(ValidationMessageFactory.createError((Element)messageMethod, "MessageMethod does not have an usable constructor for the return type %s.", returnType.name()));
            } else {
                boolean usableConstructor;
                boolean hasMessageConstructor = throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasStringConstructor();
                boolean bl = usableConstructor = throwableReturnType.hasDefaultConstructor() || throwableReturnType.hasStringAndThrowableConstructor() || throwableReturnType.hasStringConstructor() || throwableReturnType.hasThrowableAndStringConstructor() || throwableReturnType.hasThrowableConstructor();
                if (!usableConstructor) {
                    messages.add(ValidationMessageFactory.createError((Element)messageMethod, "MessageMethod does not have an usable constructor for the return type %s.", returnType.name()));
                } else if (!hasMessageConstructor) {
                    messages.add(ValidationMessageFactory.createWarning(messageMethod, "The message cannot be set via the throwable constructor and will be ignored."));
                }
            }
        } else {
            if (!returnType.isAssignableFrom(String.class)) {
                messages.add(ValidationMessageFactory.createError((Element)messageMethod, "Message bundle method (%s) has an invalid return type of %s.", messageMethod.name(), returnType.name()));
            }
            if (ElementHelper.isAnnotatedWith(messageMethod, ConstructType.class)) {
                messages.add(ValidationMessageFactory.createError(messageMethod, "ConstructType annotation requires a throwable return type"));
            }
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLogger(Set<MessageMethod> messageMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (MessageMethod messageMethod : messageMethods) {
            if (messageMethod.isLoggerMethod()) {
                messages.addAll(this.validateLoggerMethod(messageMethod));
                continue;
            }
            messages.addAll(this.validateBundleMethod(messageMethod));
            if (!ElementHelper.isAnnotatedWith(messageMethod, Once.class)) continue;
            messages.add(ValidationMessageFactory.createError(messageMethod, "Only @LogMessage method can be annoted with @Once"));
        }
        return messages;
    }

    private Collection<ValidationMessage> validateLoggerMethod(MessageMethod messageMethod) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (messageMethod.returnType().asType().getKind() != TypeKind.VOID) {
            messages.add(ValidationMessageFactory.createError(messageMethod, "Message logger methods can only have a void return type."));
        }
        return messages;
    }

    private Set<MessageMethod> getAllMethods(MessageInterface messageInterface) {
        if (ElementHelper.isAnnotatedWith(messageInterface, MessageBundle.class) || ElementHelper.isAnnotatedWith(messageInterface, MessageLogger.class)) {
            LinkedHashSet<MessageMethod> messageMethods = new LinkedHashSet<MessageMethod>();
            for (MessageMethod messageMethod : messageInterface.methods()) {
                messageMethods.add(messageMethod);
            }
            for (MessageInterface msgInterface : messageInterface.extendedInterfaces()) {
                messageMethods.addAll(this.getAllMethods(msgInterface));
            }
            return messageMethods;
        }
        return Collections.emptySet();
    }

    private boolean isTypeAssignableFrom(Element element, Class<?> type) {
        TypeMirror elementType = element.asType();
        if (elementType.getKind() == TypeKind.ARRAY) {
            elementType = ((ArrayType)elementType).getComponentType();
        }
        if (this.types.isAssignable(this.types.erasure(elementType), this.elements.getTypeElement(Collection.class.getCanonicalName()).asType())) {
            elementType = this.types.erasure(((DeclaredType)elementType).getTypeArguments().iterator().next());
        }
        TypeMirror classType = this.elements.getTypeElement(type.getCanonicalName()).asType();
        return this.types.isAssignable(elementType, classType);
    }
}

