/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JFiler;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JSources;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.processor.apt.ProcessingException;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

public abstract class ClassModel {
    private static final String INSTANCE_FIELD_NAME = "INSTANCE";
    private static final String GET_INSTANCE_METHOD_NAME = "readResolve";
    private final JSources sources;
    private final JClassDef classDef;
    protected final JSourceFile sourceFile;
    private final MessageInterface messageInterface;
    private final String className;
    private final String superClassName;
    private final String format;
    private final Map<String, JMethodDef> messageMethods;
    private final Map<String, JVarDeclaration> messageFields;

    ClassModel(Filer filer, MessageInterface messageInterface, String className, String superClassName) {
        this.messageInterface = messageInterface;
        this.className = messageInterface.packageName() + "." + className;
        this.superClassName = superClassName;
        this.sources = JDeparser.createSources((JFiler)JFiler.newInstance((Filer)filer), (FormatPreferences)new FormatPreferences(new Properties()));
        this.sourceFile = this.sources.createSourceFile(messageInterface.packageName(), className);
        this.classDef = this.sourceFile._class(32, className);
        int idLen = messageInterface.getIdLength();
        this.format = idLen > 0 ? "%s%0" + messageInterface.getIdLength() + "d: %s" : "%s%d: %s";
        this.messageMethods = new HashMap<String, JMethodDef>();
        this.messageFields = new HashMap<String, JVarDeclaration>();
    }

    public final MessageInterface messageInterface() {
        return this.messageInterface;
    }

    public final void generateAndWrite() throws IOException {
        this.generateModel();
        this.sources.writeSources();
        JDeparser.dropCaches();
    }

    JClassDef generateModel() throws IllegalStateException {
        JType generatedType = JTypes.$t(Generated.class);
        this.sourceFile._import(generatedType);
        this.classDef.annotate(generatedType).value("value", this.getClass().getName()).value("date", JExprs.str((String)ClassModelHelper.generatedDateValue()));
        this.classDef.docComment().text("Warning this class consists of generated code.");
        if (this.superClassName != null) {
            this.classDef._extends(this.superClassName);
        }
        this.classDef._implements(new JType[]{JTypes.typeOf((TypeMirror)this.messageInterface.asType())});
        if (!this.messageInterface.extendedInterfaces().isEmpty()) {
            for (MessageInterface intf : this.messageInterface.extendedInterfaces()) {
                JType interfaceName = JTypes.typeOf((TypeMirror)intf.asType());
                this.sourceFile._import(interfaceName);
                this.classDef._implements(new JType[]{interfaceName});
            }
        }
        JType serializable = JTypes.$t(Serializable.class);
        this.sourceFile._import(serializable);
        this.classDef._implements(new JType[]{serializable});
        this.classDef.field(74, JType.LONG, "serialVersionUID", JExprs.decimal((long)1L));
        return this.classDef;
    }

    JMethodDef addMessageMethod(MessageMethod messageMethod) {
        return this.addMessageMethod(messageMethod, messageMethod.message().value());
    }

    JMethodDef addMessageMethod(MessageMethod messageMethod, String messageValue) {
        if (messageValue == null) {
            return null;
        }
        String methodName = messageMethod.isOverloaded() ? messageMethod.name() + messageMethod.formatParameterCount() : messageMethod.name();
        JMethodDef method = this.messageMethods.get(messageMethod.messageMethodName());
        if (method == null) {
            JVarDeclaration field = this.messageFields.get(methodName);
            if (field == null) {
                String msg = this.messageInterface.projectCode() != null && !this.messageInterface.projectCode().isEmpty() && messageMethod.message().hasId() ? String.format(this.format, this.messageInterface.projectCode(), messageMethod.message().id(), messageValue) : messageValue;
                field = this.classDef.field(74, String.class, methodName, JExprs.str((String)msg));
                this.messageFields.put(field.name(), field);
            }
            method = this.classDef.method(16, String.class, messageMethod.messageMethodName());
            method.body()._return((JExpr)JExprs.$v((JVarDeclaration)field));
            this.messageMethods.put(messageMethod.messageMethodName(), method);
        }
        return method;
    }

    public final String qualifiedClassName() {
        return this.className;
    }

    protected JMethodDef createReadResolveMethod() {
        JType type = JTypes.typeOf((JClassDef)this.classDef);
        JVarDeclaration instance = this.classDef.field(98, type, INSTANCE_FIELD_NAME, (JExpr)type._new());
        JMethodDef readResolveMethod = this.classDef.method(16, Object.class, GET_INSTANCE_METHOD_NAME);
        readResolveMethod.body()._return((JExpr)JExprs.$v((JVarDeclaration)instance));
        return readResolveMethod;
    }

    JCall createLocaleGetter(String locale, boolean override) {
        String methodName = "getLoggingLocale";
        JType localeType = JTypes.typeOf(Locale.class);
        this.sourceFile._import(localeType);
        JVarDeclaration defaultInstance = this.classDef.field(74, localeType, "LOCALE", this.determineLocale(locale, localeType));
        JMethodDef method = this.classDef.method(16, localeType, "getLoggingLocale");
        if (override) {
            method.annotate(Override.class);
        }
        method.body()._return((JExpr)JExprs.$v((JVarDeclaration)defaultInstance));
        return JExprs.call((String)"getLoggingLocale");
    }

    private JExpr determineLocale(String locale, JType localeType) {
        Object initializer;
        if (locale == null) {
            String bcp47Value = this.messageInterface.isAnnotatedWith(MessageBundle.class) ? this.messageInterface.getAnnotation(MessageBundle.class).rootLocale() : (this.messageInterface.isAnnotatedWith(MessageLogger.class) ? this.messageInterface.getAnnotation(MessageLogger.class).rootLocale() : "");
            initializer = bcp47Value.isEmpty() ? localeType.$v("ROOT") : localeType.call("forLanguageTag").arg(JExprs.str((String)bcp47Value));
        } else if ("en_CA".equals(locale)) {
            initializer = localeType.$v("CANADA");
        } else if ("fr_CA".equals(locale)) {
            initializer = localeType.$v("CANADA_FRENCH");
        } else if ("zh".equals(locale)) {
            initializer = localeType.$v("CHINESE");
        } else if ("en".equals(locale)) {
            initializer = localeType.$v("ENGLISH");
        } else if ("fr_FR".equals(locale)) {
            initializer = localeType.$v("FRANCE");
        } else if ("fr".equals(locale)) {
            initializer = localeType.$v("FRENCH");
        } else if ("de".equals(locale)) {
            initializer = localeType.$v("GERMAN");
        } else if ("de_DE".equals(locale)) {
            initializer = localeType.$v("GERMANY");
        } else if ("it".equals(locale)) {
            initializer = localeType.$v("ITALIAN");
        } else if ("it_IT".equals(locale)) {
            initializer = localeType.$v("ITALY");
        } else if ("ja_JP".equals(locale)) {
            initializer = localeType.$v("JAPAN");
        } else if ("ja".equals(locale)) {
            initializer = localeType.$v("JAPANESE");
        } else if ("ko_KR".equals(locale)) {
            initializer = localeType.$v("KOREA");
        } else if ("ko".equals(locale)) {
            initializer = localeType.$v("KOREAN");
        } else if ("zh_CN".equals(locale)) {
            initializer = localeType.$v("SIMPLIFIED_CHINESE");
        } else if ("zh_TW".equals(locale)) {
            initializer = localeType.$v("TRADITIONAL_CHINESE");
        } else if ("en_UK".equals(locale)) {
            initializer = localeType.$v("UK");
        } else if ("en_US".equals(locale)) {
            initializer = localeType.$v("US");
        } else {
            JCall newInstance = localeType._new();
            String[] parts = locale.split("_");
            if (parts.length > 3) {
                throw new ProcessingException((Element)this.messageInterface, "Failed to parse %s to a Locale.", locale);
            }
            for (String arg : parts) {
                newInstance.arg(JExprs.str((String)arg));
            }
            initializer = newInstance;
        }
        return initializer;
    }
}

