/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JIf;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ThrowableType;

abstract class ImplementationClassModel
extends ClassModel {
    ImplementationClassModel(Filer filer, MessageInterface messageInterface) {
        super(filer, messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
    }

    @Override
    protected JClassDef generateModel() throws IllegalStateException {
        JClassDef classDef = super.generateModel();
        classDef._implements(new Class[]{Serializable.class});
        classDef.field(74, JType.LONG, "serialVersionUID", JExprs.decimal((long)1L));
        return classDef;
    }

    /*
     * WARNING - void declaration
     */
    void createBundleMethod(JClassDef classDef, MessageMethod messageMethod) {
        void var14_19;
        JCall formatterCall;
        this.addMessageMethod(messageMethod);
        JType returnType = JTypes.$t((String)messageMethod.returnType().name());
        JMethodDef method = classDef.method(34, returnType, messageMethod.name());
        method.annotate(Override.class);
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        MessageMethod.Message message = messageMethod.message();
        boolean noFormatParameters = messageMethod.parameters(Parameter.ParameterType.FORMAT).isEmpty();
        switch (message.format()) {
            case MESSAGE_FORMAT: {
                if (noFormatParameters) {
                    formatterCall = JExprs.call((String)messageMethod.messageMethodName());
                    break;
                }
                JType formatter = JTypes.$t(MessageFormat.class);
                formatterCall = formatter.call("format");
                formatterCall.arg((JExpr)JExprs.call((String)messageMethod.messageMethodName()));
                break;
            }
            case PRINTF: {
                JType formatter = JTypes.$t(String.class);
                formatterCall = formatter.call("format").arg((JExpr)JExprs.call((String)messageMethod.messageMethodName()));
                break;
            }
            default: {
                formatterCall = JExprs.call((String)messageMethod.messageMethodName());
            }
        }
        Set<Parameter> allParameters = messageMethod.parameters(Parameter.ParameterType.ANY);
        LinkedHashMap<String, JParamDeclaration> fields = new LinkedHashMap<String, JParamDeclaration>();
        LinkedHashMap<String, JParamDeclaration> properties = new LinkedHashMap<String, JParamDeclaration>();
        ArrayList<String> parameterNames = new ArrayList<String>(allParameters.size());
        for (Parameter parameter : allParameters) {
            parameterNames.add(parameter.name());
        }
        ArrayList<Object> args = new ArrayList<Object>();
        block12: for (Parameter parameter : allParameters) {
            JParamDeclaration var = parameter.isVarArgs() ? method.varargParam(2, JTypes.$t((String)parameter.type()), parameter.name()) : method.param(2, JTypes.typeOf((TypeMirror)((Element)parameter.reference()).asType()), parameter.name());
            String formatterClass = parameter.formatterClass();
            switch (parameter.parameterType()) {
                case FORMAT: {
                    if (formatterCall == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    if (formatterClass == null) {
                        if (parameter.isArray() || parameter.isVarArgs()) {
                            args.add(JTypes.$t(Arrays.class).call("toString").arg((JExpr)JExprs.$v((JParamDeclaration)var)));
                            break;
                        }
                        args.add(JExprs.$v((JParamDeclaration)var));
                        break;
                    }
                    args.add(JTypes.$t((String)formatterClass)._new().arg((JExpr)JExprs.$v((JParamDeclaration)var)));
                    break;
                }
                case TRANSFORM: {
                    if (formatterCall == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    JAssignableExpr transformVar = this.createTransformVar(parameterNames, body, parameter, (JExpr)JExprs.$v((JParamDeclaration)var));
                    if (formatterClass == null) {
                        args.add(transformVar);
                        break;
                    }
                    args.add(JTypes.$t((String)formatterClass)._new().arg((JExpr)transformVar));
                    break;
                }
                case POS: {
                    if (formatterCall == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    Pos pos = parameter.pos();
                    int[] positions = pos.value();
                    Transform[] transform = pos.transform();
                    for (int i = 0; i < positions.length; ++i) {
                        int index = positions[i] - 1;
                        if (transform != null && transform.length > 0) {
                            JAssignableExpr tVar = this.createTransformVar(parameterNames, method.body(), parameter, transform[i], (JExpr)JExprs.$v((JParamDeclaration)var));
                            if (index < args.size()) {
                                args.add(index, tVar);
                                continue;
                            }
                            args.add(tVar);
                            continue;
                        }
                        if (index < args.size()) {
                            args.add(index, JExprs.$v((JParamDeclaration)var));
                            continue;
                        }
                        args.add(JExprs.$v((JParamDeclaration)var));
                    }
                    continue block12;
                }
                case FIELD: {
                    fields.put(parameter.targetName(), var);
                    break;
                }
                case PROPERTY: {
                    properties.put(parameter.targetName(), var);
                }
            }
        }
        for (JExpr jExpr : args) {
            formatterCall.arg(jExpr);
        }
        if (messageMethod.returnType().isThrowable()) {
            JAssignableExpr jAssignableExpr = JExprs.$v((JVarDeclaration)this.initCause(messageMethod, body, formatterCall));
        } else {
            JCall jCall = formatterCall;
        }
        for (Map.Entry entry : fields.entrySet()) {
            body.assign(var14_19.field((String)entry.getKey()), (JExpr)JExprs.$v((JParamDeclaration)((JParamDeclaration)entry.getValue())));
        }
        for (Map.Entry entry : properties.entrySet()) {
            body.add((JExpr)var14_19.call((String)entry.getKey()).arg((JExpr)JExprs.$v((JParamDeclaration)((JParamDeclaration)entry.getValue()))));
        }
        body._return((JExpr)var14_19);
    }

    JAssignableExpr createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, JExpr var) {
        return this.createTransformVar(parameterNames, methodBody, param, param.transform(), var);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JAssignableExpr createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, Transform transform, JExpr var) {
        JAssignableExpr result;
        List<Transform.TransformType> transformTypes = Arrays.asList(transform.value());
        if (transformTypes.contains(Transform.TransformType.GET_CLASS)) {
            if (transformTypes.size() == 1) {
                String paramName = this.getUniqueName(parameterNames, param, "Class");
                parameterNames.add(paramName);
                result = JExprs.$v((JVarDeclaration)methodBody.var(2, JTypes.$t(Class.class), paramName));
                JIf stmt = methodBody._if(var.eq(JExpr.NULL));
                stmt.block(JBlock.Braces.REQUIRED).assign(result, JExpr.NULL);
                stmt._else().assign(result, (JExpr)var.call("getClass"));
                return result;
            } else {
                String paramName = this.getUniqueName(parameterNames, param, "HashCode");
                parameterNames.add(paramName);
                result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
                JIf stmt = methodBody._if(var.eq(JExpr.NULL));
                stmt.assign(result, JExpr.ZERO);
                if (transformTypes.contains(Transform.TransformType.HASH_CODE)) {
                    stmt._else().assign(result, (JExpr)var.call("getClass").call("hashCode"));
                    return result;
                } else {
                    if (!transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE)) throw new IllegalStateException(String.format("Invalid transform type combination: %s", transformTypes));
                    stmt._else().assign(result, (JExpr)JTypes.$t(System.class).call("identityHashCode").arg((JExpr)var.call("getClass")));
                }
            }
            return result;
        } else if (transformTypes.contains(Transform.TransformType.HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            if (param.isArray() || param.isVarArgs()) {
                stmt._else().assign(result, (JExpr)JTypes.$t(Arrays.class).call("hashCode").arg(var));
                return result;
            } else {
                stmt._else().assign(result, (JExpr)var.call("hashCode"));
            }
            return result;
        } else if (transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            stmt._else().assign(result, (JExpr)JTypes.$t(System.class).call("identityHashCode").arg(var));
            return result;
        } else {
            if (!transformTypes.contains(Transform.TransformType.SIZE)) throw new IllegalStateException(String.format("Invalid transform type: %s", transformTypes));
            String paramName = this.getUniqueName(parameterNames, param, "Size");
            parameterNames.add(paramName);
            result = JExprs.$v((JVarDeclaration)methodBody.var(2, JType.INT, paramName));
            JIf stmt = methodBody._if(var.eq(JExpr.NULL));
            stmt.assign(result, JExpr.ZERO);
            if (param.isArray() || param.isVarArgs()) {
                stmt._else().assign(result, (JExpr)var.field("length"));
                return result;
            } else if (param.isSubtypeOf(Map.class) || param.isSubtypeOf(Collection.class)) {
                stmt._else().assign(result, (JExpr)var.call("size"));
                return result;
            } else {
                if (!param.isSubtypeOf(CharSequence.class)) throw new IllegalStateException(String.format("Invalid type for %s. Must be an array, %s, %s or %s.", Transform.TransformType.SIZE, Collection.class.getName(), Map.class.getName(), CharSequence.class.getName()));
                stmt._else().assign(result, (JExpr)var.call("length"));
            }
        }
        return result;
    }

    private String getUniqueName(List<String> parameterNames, Parameter parameter, String suffix) {
        String result;
        String string = result = suffix == null ? parameter.name() : parameter.name().concat(suffix);
        if (parameterNames.contains(result)) {
            return this.getUniqueName(parameterNames, new StringBuilder(result), 0);
        }
        return result;
    }

    private String getUniqueName(List<String> parameterNames, StringBuilder sb, int index) {
        String result = sb.append(index).toString();
        if (parameterNames.contains(result)) {
            return this.getUniqueName(parameterNames, sb, index + 1);
        }
        return result;
    }

    private JVarDeclaration initCause(MessageMethod messageMethod, JBlock body, JCall format) {
        boolean callInitCause = false;
        ThrowableType returnType = messageMethod.returnType().throwableReturnType();
        JType type = JTypes.$t((String)returnType.name());
        JCall result = type._new();
        JVarDeclaration resultField = body.var(2, type, "result", (JExpr)result);
        if (returnType.useConstructionParameters()) {
            block3: for (Parameter param : returnType.constructionParameters()) {
                switch (param.parameterType()) {
                    case MESSAGE: {
                        result.arg((JExpr)format);
                        continue block3;
                    }
                }
                result.arg((JExpr)JExprs.$v((String)param.name()));
            }
        } else if (returnType.hasStringAndThrowableConstructor() && messageMethod.hasCause()) {
            result.arg((JExpr)format).arg((JExpr)JExprs.$v((String)messageMethod.cause().name()));
        } else if (returnType.hasThrowableAndStringConstructor() && messageMethod.hasCause()) {
            result.arg((JExpr)JExprs.$v((String)messageMethod.cause().name())).arg((JExpr)format);
        } else if (returnType.hasStringConstructor()) {
            result.arg((JExpr)format);
            if (messageMethod.hasCause()) {
                callInitCause = true;
            }
        } else if (returnType.hasThrowableConstructor() && messageMethod.hasCause()) {
            result.arg((JExpr)JExprs.$v((String)messageMethod.cause().name()));
        } else if (returnType.hasStringAndThrowableConstructor() && !messageMethod.hasCause()) {
            result.arg((JExpr)format).arg(JExpr.NULL);
        } else if (returnType.hasThrowableAndStringConstructor() && !messageMethod.hasCause()) {
            result.arg(JExpr.NULL).arg((JExpr)format);
        } else if (messageMethod.hasCause()) {
            callInitCause = true;
        }
        if (callInitCause) {
            body.add((JExpr)JExprs.$v((JVarDeclaration)resultField).call("initCause").arg((JExpr)JExprs.$v((String)messageMethod.cause().name())));
        }
        JType arrays = JTypes.$t(Arrays.class);
        JVarDeclaration st = body.var(2, JTypes.$t(StackTraceElement.class).array(), "st", (JExpr)JExprs.$v((JVarDeclaration)resultField).call("getStackTrace"));
        body.add((JExpr)JExprs.$v((JVarDeclaration)resultField).call("setStackTrace").arg((JExpr)arrays.call("copyOfRange").arg((JExpr)JExprs.$v((JVarDeclaration)st)).arg(JExpr.ONE).arg((JExpr)JExprs.$v((JVarDeclaration)st).field("length"))));
        return resultField;
    }

    protected final void addThrownTypes(MessageMethod messageMethod, JMethodDef jMethod) {
        for (ThrowableType thrownType : messageMethod.thrownTypes()) {
            jMethod._throws(thrownType.name());
        }
    }
}

