/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.logging.processor.model.MessageInterface;

public final class ClassModelHelper {
    private static final String STRING_ID_FORMAT2 = "%s%06d: ";

    private ClassModelHelper() {
    }

    static String generatedDateValue() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return sdf.format(new Date());
    }

    public static String formatMessageId(String projectCode, int padLength, int messageId) {
        return String.format(STRING_ID_FORMAT2, projectCode, messageId);
    }

    public static String implementationClassName(MessageInterface messageInterface) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder(messageInterface.name());
        switch (messageInterface.getAnnotatedType()) {
            case MESSAGE_BUNDLE: {
                result.append("_$bundle");
                break;
            }
            case MESSAGE_LOGGER: {
                result.append("_$logger");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Message interface %s is not a message bundle or message logger.", messageInterface));
            }
        }
        return result.toString();
    }

    public static String implementationClassName(MessageInterface messageInterface, String translationSuffix) throws IllegalArgumentException {
        return ClassModelHelper.implementationClassName(messageInterface) + translationSuffix;
    }
}

