/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.jboss.logging.processor.Tools;
import org.jboss.logging.processor.apt.Annotations;
import org.jboss.logging.processor.model.MessageObject;

public final class ElementHelper {
    private ElementHelper() {
    }

    public static boolean isAnnotatedWith(Element element, Class<? extends Annotation> clazz) {
        if (element == null) {
            throw new IllegalArgumentException("The element parameter is null");
        }
        Annotation annotation = element.getAnnotation(clazz);
        return annotation != null;
    }

    public static boolean isAnnotatedWith(Element element, Class<? extends Annotation> clazz1, Class<? extends Annotation> clazz2) {
        return ElementHelper.isAnnotatedWith(element, clazz1) || ElementHelper.isAnnotatedWith(element, clazz2);
    }

    public static String getPrimaryClassNamePrefix(TypeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String translationFileName = element.getSimpleName().toString();
        for (Element enclosingElt = element.getEnclosingElement(); enclosingElt != null && enclosingElt instanceof TypeElement; enclosingElt = enclosingElt.getEnclosingElement()) {
            translationFileName = String.format("%s$%s", enclosingElt.getSimpleName().toString(), translationFileName);
        }
        return translationFileName;
    }

    public static Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!((Object)methodName).equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }

    public static Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName, int paramCount) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!((Object)methodName).equals(method.getSimpleName()) || ElementHelper.parameterCount(method.getParameters()) != paramCount) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean hasCause(Collection<? extends VariableElement> params) {
        Annotations annotations = Tools.annotations();
        for (VariableElement variableElement : params) {
            if (!annotations.hasCauseAnnotation(variableElement)) continue;
            return true;
        }
        return false;
    }

    public static int parameterCount(Collection<? extends VariableElement> params) {
        Annotations annotations = Tools.annotations();
        int result = params.size();
        for (VariableElement variableElement : params) {
            if (!annotations.hasParamAnnotation(variableElement) && !annotations.hasFieldAnnotation(variableElement) && !annotations.hasPropertyAnnotation(variableElement)) continue;
            --result;
        }
        return result - (ElementHelper.hasCause(params) ? 1 : 0);
    }

    public static boolean inheritsMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        Annotations annotations = Tools.annotations();
        if (annotations.hasMessageAnnotation(method)) {
            return false;
        }
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!annotations.hasMessageAnnotation(m)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverloaded(Collection<ExecutableElement> methods, ExecutableElement method) {
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!((Object)method.getSimpleName()).equals(m.getSimpleName()) || ElementHelper.parameterCount(method.getParameters()) == ElementHelper.parameterCount(m.getParameters())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(TypeElement typeElement, Class<?> type) {
        if (type.getName().equals(typeElement.getQualifiedName().toString())) {
            return true;
        }
        for (Class<?> intf : type.getInterfaces()) {
            if (!ElementHelper.isAssignableFrom(typeElement, intf)) continue;
            return true;
        }
        return type.getSuperclass() != null && ElementHelper.isAssignableFrom(typeElement, type.getSuperclass());
    }

    public static boolean isAssignableFrom(TypeMirror typeMirror, Class<?> type) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType dclType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)dclType.asElement();
            return ElementHelper.isAssignableFrom(typeElement, type);
        }
        for (Class<?> intf : type.getInterfaces()) {
            if (!ElementHelper.isAssignableFrom(typeMirror, intf)) continue;
            return true;
        }
        return type.getSuperclass() != null && ElementHelper.isAssignableFrom(typeMirror, type.getSuperclass());
    }

    public static boolean isAssignableFrom(Class<?> type, TypeElement typeElement) {
        if (type.getName().equals(typeElement.getQualifiedName().toString())) {
            return true;
        }
        List<? extends TypeMirror> types = typeElement.getInterfaces();
        for (TypeMirror typeMirror : types) {
            if (!ElementHelper.isAssignableFrom(type, typeMirror)) continue;
            return true;
        }
        return ElementHelper.isAssignableFrom(type, typeElement.getSuperclass());
    }

    public static boolean isAssignableFrom(Class<?> type, TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType dclType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)dclType.asElement();
            return ElementHelper.isAssignableFrom(type, typeElement);
        }
        return false;
    }

    public static String typeToString(Class<?> type) {
        return ElementHelper.typeToString(type.getName());
    }

    public static String typeToString(String qualifiedType) {
        return qualifiedType.replace("$", ".");
    }

    public static Element fromMessageObject(MessageObject object) {
        if (object.reference() instanceof Element) {
            return (Element)object.reference();
        }
        return null;
    }
}

