/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.lang.annotation.Annotation;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.Annotations;
import org.jboss.logging.Cause;
import org.jboss.logging.FormatWith;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.MessageLogger;

public class BaseAnnotations
implements Annotations {
    public static final Class<FormatWith> FORMAT_WITH_ANNOTATION = FormatWith.class;
    public static final Class<Cause> CAUSE_ANNOTATION = Cause.class;
    public static final Class<MessageBundle> MESSAGE_BUNDLE_ANNOTATION = MessageBundle.class;
    public static final Class<MessageLogger> MESSAGE_LOGGER_ANNOTATION = MessageLogger.class;
    public static final Class<LogMessage> LOG_MESSAGE_ANNOTATION = LogMessage.class;
    public static final Class<Message> MESSAGE_ANNOTATION = Message.class;

    public Class<? extends Annotation> cause() {
        return CAUSE_ANNOTATION;
    }

    public Class<? extends Annotation> formatWith() {
        return FORMAT_WITH_ANNOTATION;
    }

    public Class<? extends Annotation> logMessage() {
        return LOG_MESSAGE_ANNOTATION;
    }

    public Class<? extends Annotation> message() {
        return MESSAGE_ANNOTATION;
    }

    public Class<? extends Annotation> messageBundle() {
        return MESSAGE_BUNDLE_ANNOTATION;
    }

    public Class<? extends Annotation> messageLogger() {
        return MESSAGE_LOGGER_ANNOTATION;
    }

    public Annotations.FormatType messageFormat(ExecutableElement method) {
        Annotations.FormatType result = null;
        Message message = method.getAnnotation(MESSAGE_ANNOTATION);
        if (message != null) {
            switch (message.format()) {
                case MESSAGE_FORMAT: {
                    result = Annotations.FormatType.MESSAGE_FORMAT;
                    break;
                }
                case PRINTF: {
                    result = Annotations.FormatType.PRINTF;
                }
            }
        }
        return result;
    }

    public String projectCode(TypeElement intf) {
        String result = null;
        MessageBundle bundle = intf.getAnnotation(MESSAGE_BUNDLE_ANNOTATION);
        MessageLogger logger = intf.getAnnotation(MESSAGE_LOGGER_ANNOTATION);
        if (bundle != null) {
            result = bundle.projectCode();
        } else if (logger != null) {
            result = logger.projectCode();
        }
        return result;
    }

    public boolean hasMessageId(ExecutableElement method) {
        Message message = method.getAnnotation(MESSAGE_ANNOTATION);
        return message == null ? false : message.id() != 0 && message.id() != -1;
    }

    public boolean inheritsMessageId(ExecutableElement method) {
        Message message = method.getAnnotation(MESSAGE_ANNOTATION);
        return message == null ? false : message.id() == -1;
    }

    public int messageId(ExecutableElement method) {
        Message message = method.getAnnotation(MESSAGE_ANNOTATION);
        return message == null ? 0 : message.id();
    }

    public String messageValue(ExecutableElement method) {
        Message message = method.getAnnotation(MESSAGE_ANNOTATION);
        return message == null ? null : message.value();
    }

    public String loggerMethod(ExecutableElement method, Annotations.FormatType formatType) {
        return "log" + (formatType == null ? "" : Character.valueOf(formatType.logType()));
    }

    public String logLevel(ExecutableElement method) {
        String result = null;
        LogMessage logMessage = method.getAnnotation(LOG_MESSAGE_ANNOTATION);
        if (logMessage != null) {
            Logger.Level logLevel = logMessage.level() == null ? Logger.Level.INFO : logMessage.level();
            result = String.format("%s.%s.%s", Logger.class.getSimpleName(), Logger.Level.class.getSimpleName(), logLevel.name());
        }
        return result;
    }
}

