/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.logmanager;

import java.util.EnumMap;
import java.util.Map;
import org.jboss.logging.AbstractLoggerPluginInstance;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;

public final class LoggerPluginInstanceImpl
extends AbstractLoggerPluginInstance {
    private final Logger logger;
    private static final Map<Logger.Level, Level> LEVELS;

    public LoggerPluginInstanceImpl(String name, String resourceBundleName, Logger logger, LoggerPlugin loggerPlugin) {
        super(name, resourceBundleName, loggerPlugin);
        this.logger = logger;
    }

    public boolean isEnabled(Logger.Level level) {
        return this.logger.isLoggable((java.util.logging.Level)LEVELS.get(level));
    }

    public void log(Logger.Level level, String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (params == null) {
            this.logger.log(loggerFqcn, (java.util.logging.Level)LEVELS.get(level), String.valueOf(message), t);
        } else {
            this.logger.log(loggerFqcn, (java.util.logging.Level)LEVELS.get(level), String.valueOf(message), ExtLogRecord.FormatStyle.MESSAGE_FORMAT, params, t);
        }
    }

    public void logf(Logger.Level level, String loggerFqcn, String format, Object[] params, Throwable t) {
        if (params == null) {
            this.logger.log(loggerFqcn, (java.util.logging.Level)LEVELS.get(level), format, t);
        } else {
            this.logger.log(loggerFqcn, (java.util.logging.Level)LEVELS.get(level), format, ExtLogRecord.FormatStyle.PRINTF, params, t);
        }
    }

    static {
        EnumMap<Logger.Level, Level> map = new EnumMap<Logger.Level, Level>(Logger.Level.class);
        map.put(Logger.Level.TRACE, Level.TRACE);
        map.put(Logger.Level.DEBUG, Level.DEBUG);
        map.put(Logger.Level.INFO, Level.INFO);
        map.put(Logger.Level.WARN, Level.WARN);
        map.put(Logger.Level.ERROR, Level.ERROR);
        map.put(Logger.Level.FATAL, Level.FATAL);
        LEVELS = map;
    }
}

