/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jnp.interfaces.NamingContextFactory;

public class BridgeNamingContextFactory
extends NamingContextFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        Context primaryCtx;
        Context bridgeCtx = primaryCtx = super.getInitialContext(env);
        Object providerURL2 = env.get("org.jboss.naming.provider.url2");
        if (providerURL2 != null) {
            Hashtable env2 = (Hashtable)env.clone();
            env2.put("java.naming.provider.url", providerURL2);
            Context secondaryCtx = super.getInitialContext(env2);
            BridgeContext h = new BridgeContext(primaryCtx, secondaryCtx);
            Class[] interfaces = new Class[]{Context.class};
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            bridgeCtx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)h);
        }
        return bridgeCtx;
    }

    static class BridgeContext
    implements InvocationHandler {
        private Context primaryCtx;
        private Context secondaryCtx;

        BridgeContext(Context primaryCtx, Context secondaryCtx) {
            this.primaryCtx = primaryCtx;
            this.secondaryCtx = secondaryCtx;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = null;
            try {
                value = method.invoke((Object)this.primaryCtx, args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof NameNotFoundException && method.getName().equals("lookup")) {
                    try {
                        value = method.invoke((Object)this.secondaryCtx, args);
                    }
                    catch (InvocationTargetException e1) {
                        throw e1.getTargetException();
                    }
                }
                throw t;
            }
            return value;
        }
    }
}

