/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.StrongInternPool;
import org.jboss.jandex.Type;

public final class Indexer {
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACEMETHODREF = 11;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_NAMEANDTYPE = 12;
    private static final int CONSTANT_UTF8 = 1;
    private static final byte[] RUNTIME_ANNOTATIONS = new byte[]{82, 117, 110, 116, 105, 109, 101, 86, 105, 115, 105, 98, 108, 101, 65, 110, 110, 111, 116, 97, 116, 105, 111, 110, 115};
    private static final byte[] RUNTIME_PARAM_ANNOTATIONS = new byte[]{82, 117, 110, 116, 105, 109, 101, 86, 105, 115, 105, 98, 108, 101, 80, 97, 114, 97, 109, 101, 116, 101, 114, 65, 110, 110, 111, 116, 97, 116, 105, 111, 110, 115};
    private static final int RUNTIME_ANNOTATIONS_LEN = RUNTIME_ANNOTATIONS.length;
    private static final int RUNTIME_PARAM_ANNOTATIONS_LEN = RUNTIME_PARAM_ANNOTATIONS.length;
    private static final int HAS_RUNTIME_ANNOTATION = 1;
    private static final int HAS_RUNTIME_PARAM_ANNOTATION = 2;
    private byte[] constantPool;
    private int[] constantPoolOffsets;
    private byte[] constantPoolAnnoAttrributes;
    private ClassInfo currentClass;
    private volatile ClassInfo publishClass;
    private HashMap<DotName, List<AnnotationInstance>> classAnnotations;
    private StrongInternPool<String> internPool;
    private Map<DotName, List<AnnotationInstance>> masterAnnotations;
    private Map<DotName, List<ClassInfo>> subclasses;
    private Map<DotName, List<ClassInfo>> implementors;
    private Map<DotName, ClassInfo> classes;
    private Map<String, DotName> names;

    private static boolean match(byte[] target, int offset, byte[] expected) {
        if (target.length - offset < expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (target[offset + i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] sizeToFit(byte[] buf, int needed, int offset, int remainingEntries) {
        if (offset + needed > buf.length) {
            buf = Arrays.copyOf(buf, buf.length + Math.max(needed, (remainingEntries + 1) * 20));
        }
        return buf;
    }

    private static void skipFully(InputStream s, long n) throws IOException {
        long skipped;
        for (long total = 0L; total < n; total += skipped) {
            skipped = s.skip(n - total);
            if (skipped >= 0L) continue;
            throw new EOFException();
        }
    }

    private void initIndexMaps() {
        if (this.masterAnnotations == null) {
            this.masterAnnotations = new HashMap<DotName, List<AnnotationInstance>>();
        }
        if (this.subclasses == null) {
            this.subclasses = new HashMap<DotName, List<ClassInfo>>();
        }
        if (this.implementors == null) {
            this.implementors = new HashMap<DotName, List<ClassInfo>>();
        }
        if (this.classes == null) {
            this.classes = new HashMap<DotName, ClassInfo>();
        }
        if (this.names == null) {
            this.names = new HashMap<String, DotName>();
        }
    }

    private DotName convertToName(String name) {
        return this.convertToName(name, '.');
    }

    private DotName convertToName(String name, char delim) {
        DotName result = this.names.get(name);
        if (result != null) {
            return result;
        }
        int loc = name.lastIndexOf(delim);
        String local = this.intern(name.substring(loc + 1));
        DotName prefix = loc < 1 ? null : this.convertToName(this.intern(name.substring(0, loc)), delim);
        result = new DotName(prefix, local, true);
        this.names.put(name, result);
        return result;
    }

    private void processMethodInfo(DataInputStream data) throws IOException {
        int numMethods = data.readUnsignedShort();
        for (int i = 0; i < numMethods; ++i) {
            short flags = (short)data.readUnsignedShort();
            String name = this.intern(this.decodeUtf8Entry(data.readUnsignedShort()));
            String descriptor = this.decodeUtf8Entry(data.readUnsignedShort());
            IntegerHolder pos = new IntegerHolder();
            Type[] args = this.parseMethodArgs(descriptor, pos);
            pos.i++;
            Type returnType = this.parseType(descriptor, pos);
            MethodInfo method = new MethodInfo(this.currentClass, name, args, returnType, flags);
            this.processAttributes(data, method);
        }
    }

    private void processFieldInfo(DataInputStream data) throws IOException {
        int numFields = data.readUnsignedShort();
        for (int i = 0; i < numFields; ++i) {
            short flags = (short)data.readUnsignedShort();
            String name = this.intern(this.decodeUtf8Entry(data.readUnsignedShort()));
            Type type = this.parseType(this.decodeUtf8Entry(data.readUnsignedShort()));
            FieldInfo field = new FieldInfo(this.currentClass, name, type, flags);
            this.processAttributes(data, field);
        }
    }

    private void processAttributes(DataInputStream data, AnnotationTarget target) throws IOException {
        int numAttrs = data.readUnsignedShort();
        for (int a = 0; a < numAttrs; ++a) {
            short s;
            int index = data.readUnsignedShort();
            long attributeLen = (long)data.readInt() & 0xFFFFFFFFL;
            byte annotationAttribute = this.constantPoolAnnoAttrributes[index - 1];
            if (annotationAttribute == 1) {
                s = data.readUnsignedShort();
                while (s-- > 0) {
                    this.processAnnotation(data, target);
                }
                continue;
            }
            if (annotationAttribute == 2) {
                if (!(target instanceof MethodInfo)) {
                    throw new IllegalStateException("RuntimeVisibleParameterAnnotaitons appeared on a non-method");
                }
                s = data.readUnsignedByte();
                for (short p = 0; p < s; p = (short)((short)(p + 1))) {
                    int numAnnotations = data.readUnsignedShort();
                    while (numAnnotations-- > 0) {
                        this.processAnnotation(data, new MethodParameterInfo((MethodInfo)target, p));
                    }
                }
                continue;
            }
            Indexer.skipFully(data, attributeLen);
        }
    }

    private AnnotationInstance processAnnotation(DataInputStream data, AnnotationTarget target) throws IOException {
        String annotation = Indexer.convertClassFieldDescriptor(this.decodeUtf8Entry(data.readUnsignedShort()));
        int valuePairs = data.readUnsignedShort();
        AnnotationValue[] values = new AnnotationValue[valuePairs];
        for (int v = 0; v < valuePairs; ++v) {
            String name = this.intern(this.decodeUtf8Entry(data.readUnsignedShort()));
            values[v] = this.processAnnotationElementValue(name, data);
        }
        Arrays.sort(values, new Comparator<AnnotationValue>(){

            @Override
            public int compare(AnnotationValue o1, AnnotationValue o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        DotName annotationName = this.convertToName(annotation);
        AnnotationInstance instance = new AnnotationInstance(annotationName, target, values);
        if (target != null) {
            this.recordAnnotation(this.classAnnotations, annotationName, instance);
            this.recordAnnotation(this.masterAnnotations, annotationName, instance);
        }
        return instance;
    }

    private void recordAnnotation(Map<DotName, List<AnnotationInstance>> classAnnotations, DotName annotation, AnnotationInstance instance) {
        List<AnnotationInstance> list = classAnnotations.get(annotation);
        if (list == null) {
            list = new ArrayList<AnnotationInstance>();
            classAnnotations.put(annotation, list);
        }
        list.add(instance);
    }

    private String intern(String string) {
        return this.internPool.intern(string);
    }

    private AnnotationValue processAnnotationElementValue(String name, DataInputStream data) throws IOException {
        int tag = data.readUnsignedByte();
        switch (tag) {
            case 66: {
                return new AnnotationValue.ByteValue(name, (byte)this.decodeIntegerEntry(data.readUnsignedShort()));
            }
            case 67: {
                return new AnnotationValue.CharacterValue(name, (char)this.decodeIntegerEntry(data.readUnsignedShort()));
            }
            case 73: {
                return new AnnotationValue.IntegerValue(name, this.decodeIntegerEntry(data.readUnsignedShort()));
            }
            case 83: {
                return new AnnotationValue.ShortValue(name, (short)this.decodeIntegerEntry(data.readUnsignedShort()));
            }
            case 90: {
                return new AnnotationValue.BooleanValue(name, this.decodeIntegerEntry(data.readUnsignedShort()) > 0);
            }
            case 70: {
                return new AnnotationValue.FloatValue(name, this.decodeFloatEntry(data.readUnsignedShort()));
            }
            case 68: {
                return new AnnotationValue.DoubleValue(name, this.decodeDoubleEntry(data.readUnsignedShort()));
            }
            case 74: {
                return new AnnotationValue.LongValue(name, this.decodeLongEntry(data.readUnsignedShort()));
            }
            case 115: {
                return new AnnotationValue.StringValue(name, this.decodeUtf8Entry(data.readUnsignedShort()));
            }
            case 99: {
                return new AnnotationValue.ClassValue(name, this.parseType(this.decodeUtf8Entry(data.readUnsignedShort())));
            }
            case 101: {
                DotName type = this.parseType(this.decodeUtf8Entry(data.readUnsignedShort())).name();
                String value = this.decodeUtf8Entry(data.readUnsignedShort());
                return new AnnotationValue.EnumValue(name, type, value);
            }
            case 64: {
                return new AnnotationValue.NestedAnnotation(name, this.processAnnotation(data, null));
            }
            case 91: {
                int numValues = data.readUnsignedShort();
                AnnotationValue[] values = new AnnotationValue[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.processAnnotationElementValue("", data);
                }
                return new AnnotationValue.ArrayValue(name, values);
            }
        }
        throw new IllegalStateException("Invalid tag value: " + tag);
    }

    private void processClassInfo(DataInputStream data) throws IOException {
        int i;
        short flags = (short)data.readUnsignedShort();
        DotName thisName = this.decodeClassEntry(data.readUnsignedShort());
        int superIndex = data.readUnsignedShort();
        DotName superName = superIndex != 0 ? this.decodeClassEntry(superIndex) : null;
        int numInterfaces = data.readUnsignedShort();
        DotName[] interfaces = new DotName[numInterfaces];
        for (i = 0; i < numInterfaces; ++i) {
            interfaces[i] = this.decodeClassEntry(data.readUnsignedShort());
        }
        this.classAnnotations = new HashMap();
        this.currentClass = new ClassInfo(thisName, superName, flags, interfaces, this.classAnnotations);
        if (superName != null) {
            this.addSubclass(superName, this.currentClass);
        }
        for (i = 0; i < numInterfaces; ++i) {
            this.addImplementor(interfaces[i], this.currentClass);
        }
        this.classes.put(this.currentClass.name(), this.currentClass);
    }

    private void addSubclass(DotName superName, ClassInfo currentClass) {
        List<ClassInfo> list = this.subclasses.get(superName);
        if (list == null) {
            list = new ArrayList<ClassInfo>();
            this.subclasses.put(superName, list);
        }
        list.add(currentClass);
    }

    private void addImplementor(DotName interfaceName, ClassInfo currentClass) {
        List<ClassInfo> list = this.implementors.get(interfaceName);
        if (list == null) {
            list = new ArrayList<ClassInfo>();
            this.implementors.put(interfaceName, list);
        }
        list.add(currentClass);
    }

    private boolean isJDK11OrNewer(DataInputStream stream) throws IOException {
        int minor = stream.readUnsignedShort();
        int major = stream.readUnsignedShort();
        return major > 45 || major == 45 && minor >= 3;
    }

    private void verifyMagic(DataInputStream stream) throws IOException {
        byte[] buf = new byte[4];
        stream.readFully(buf);
        if (buf[0] != -54 || buf[1] != -2 || buf[2] != -70 || buf[3] != -66) {
            throw new IOException("Invalid Magic");
        }
    }

    private DotName decodeClassEntry(int classInfoIndex) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[classInfoIndex - 1];
        if (pool[pos] != 7) {
            throw new IllegalStateException("Constant pool entry is not a class info type: " + classInfoIndex + ":" + pos);
        }
        int nameIndex = (pool[++pos] & 0xFF) << 8 | pool[++pos] & 0xFF;
        return this.convertToName(this.decodeUtf8Entry(nameIndex), '/');
    }

    private String decodeUtf8Entry(int index) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[index - 1];
        if (pool[pos] != 1) {
            throw new IllegalStateException("Constant pool entry is not a utf8 info type: " + index + ":" + pos);
        }
        int len = (pool[++pos] & 0xFF) << 8 | pool[++pos] & 0xFF;
        return new String(pool, ++pos, len, Charset.forName("UTF-8"));
    }

    private int bitsToInt(byte[] pool, int pos) {
        return (pool[++pos] & 0xFF) << 24 | (pool[++pos] & 0xFF) << 16 | (pool[++pos] & 0xFF) << 8 | pool[++pos] & 0xFF;
    }

    private long bitsToLong(byte[] pool, int pos) {
        return ((long)pool[++pos] & 0xFFL) << 56 | ((long)pool[++pos] & 0xFFL) << 48 | ((long)pool[++pos] & 0xFFL) << 40 | ((long)pool[++pos] & 0xFFL) << 32 | (long)((pool[++pos] & 0xFF) << 24) | (long)((pool[++pos] & 0xFF) << 16) | (long)((pool[++pos] & 0xFF) << 8) | (long)(pool[++pos] & 0xFF);
    }

    private int decodeIntegerEntry(int index) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[index - 1];
        if (pool[pos] != 3) {
            throw new IllegalStateException("Constant pool entry is not an integer info type: " + index + ":" + pos);
        }
        return this.bitsToInt(pool, pos);
    }

    private long decodeLongEntry(int index) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[index - 1];
        if (pool[pos] != 5) {
            throw new IllegalStateException("Constant pool entry is not an long info type: " + index + ":" + pos);
        }
        return this.bitsToLong(pool, pos);
    }

    private float decodeFloatEntry(int index) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[index - 1];
        if (pool[pos] != 4) {
            throw new IllegalStateException("Constant pool entry is not an float info type: " + index + ":" + pos);
        }
        return Float.intBitsToFloat(this.bitsToInt(pool, pos));
    }

    private double decodeDoubleEntry(int index) {
        byte[] pool = this.constantPool;
        int[] offsets = this.constantPoolOffsets;
        int pos = offsets[index - 1];
        if (pool[pos] != 6) {
            throw new IllegalStateException("Constant pool entry is not an double info type: " + index + ":" + pos);
        }
        return Double.longBitsToDouble(this.bitsToLong(pool, pos));
    }

    private static String convertClassFieldDescriptor(String descriptor) {
        if (descriptor.charAt(0) != 'L') {
            throw new IllegalArgumentException("Non class descriptor: " + descriptor);
        }
        return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
    }

    private Type[] parseMethodArgs(String descriptor, IntegerHolder pos) {
        if (descriptor.charAt(pos.i) != '(') {
            throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
        }
        ArrayList<Type> types = new ArrayList<Type>();
        while (descriptor.charAt(++pos.i) != ')') {
            types.add(this.parseType(descriptor, pos));
        }
        return types.toArray(new Type[0]);
    }

    private Type parseType(String descriptor) {
        return this.parseType(descriptor, new IntegerHolder());
    }

    private Type parseType(String descriptor, IntegerHolder pos) {
        DotName name;
        int start = pos.i;
        char c = descriptor.charAt(start);
        Type.Kind kind = Type.Kind.PRIMITIVE;
        switch (c) {
            case 'B': {
                name = new DotName(null, "byte", true);
                break;
            }
            case 'C': {
                name = new DotName(null, "char", true);
                break;
            }
            case 'D': {
                name = new DotName(null, "double", true);
                break;
            }
            case 'F': {
                name = new DotName(null, "float", true);
                break;
            }
            case 'I': {
                name = new DotName(null, "int", true);
                break;
            }
            case 'J': {
                name = new DotName(null, "long", true);
                break;
            }
            case 'S': {
                name = new DotName(null, "short", true);
                break;
            }
            case 'Z': {
                name = new DotName(null, "boolean", true);
                break;
            }
            case 'V': {
                name = new DotName(null, "void", true);
                kind = Type.Kind.VOID;
                break;
            }
            case 'L': {
                int end = start;
                while (descriptor.charAt(++end) != ';') {
                }
                name = this.convertToName(descriptor.substring(start + 1, end), '/');
                kind = Type.Kind.CLASS;
                pos.i = end;
                break;
            }
            case '[': {
                int end = start;
                while (descriptor.charAt(++end) == '[') {
                }
                if (descriptor.charAt(end) == 'L') {
                    while (descriptor.charAt(++end) != ';') {
                    }
                }
                name = new DotName(null, descriptor.substring(start, end + 1), true);
                kind = Type.Kind.ARRAY;
                pos.i = end;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid descriptor: " + descriptor + " pos " + start);
            }
        }
        return new Type(name, kind);
    }

    private boolean processConstantPool(DataInputStream stream) throws IOException {
        int poolCount = stream.readUnsignedShort() - 1;
        byte[] buf = new byte[20 * poolCount];
        byte[] annoAttributes = new byte[poolCount];
        int[] offsets = new int[poolCount];
        boolean hasAnnotations = false;
        int offset = 0;
        block6: for (int pos = 0; pos < poolCount; ++pos) {
            int tag = stream.readUnsignedByte();
            offsets[pos] = offset;
            switch (tag) {
                case 7: 
                case 8: {
                    buf = Indexer.sizeToFit(buf, 3, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    stream.readFully(buf, offset, 2);
                    offset += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    buf = Indexer.sizeToFit(buf, 5, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    stream.readFully(buf, offset, 4);
                    offset += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    buf = Indexer.sizeToFit(buf, 9, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    stream.readFully(buf, offset, 8);
                    offset += 8;
                    ++pos;
                    continue block6;
                }
                case 1: {
                    int len = stream.readUnsignedShort();
                    buf = Indexer.sizeToFit(buf, len + 3, offset, poolCount - pos);
                    buf[offset++] = (byte)tag;
                    buf[offset++] = (byte)(len >>> 8);
                    buf[offset++] = (byte)len;
                    stream.readFully(buf, offset, len);
                    if (len == RUNTIME_ANNOTATIONS_LEN && Indexer.match(buf, offset, RUNTIME_ANNOTATIONS)) {
                        annoAttributes[pos] = 1;
                        hasAnnotations = true;
                    } else if (len == RUNTIME_PARAM_ANNOTATIONS_LEN && Indexer.match(buf, offset, RUNTIME_PARAM_ANNOTATIONS)) {
                        annoAttributes[pos] = 2;
                        hasAnnotations = true;
                    }
                    offset += len;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unknown tag! pos=" + pos + " poolCount = " + poolCount);
                }
            }
        }
        this.constantPool = buf;
        this.constantPoolOffsets = offsets;
        this.constantPoolAnnoAttrributes = annoAttributes;
        return hasAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo index(InputStream stream) throws IOException {
        try {
            DataInputStream data = new DataInputStream(new BufferedInputStream(stream));
            this.verifyMagic(data);
            if (!this.isJDK11OrNewer(data)) {
                ClassInfo classInfo = null;
                return classInfo;
            }
            this.initIndexMaps();
            this.internPool = new StrongInternPool();
            boolean hasAnnotations = this.processConstantPool(data);
            this.processClassInfo(data);
            if (!hasAnnotations) {
                ClassInfo classInfo = this.currentClass;
                return classInfo;
            }
            this.processFieldInfo(data);
            this.processMethodInfo(data);
            this.processAttributes(data, this.currentClass);
            ClassInfo classInfo = this.publishClass = this.currentClass;
            return classInfo;
        }
        finally {
            this.constantPool = null;
            this.constantPoolOffsets = null;
            this.constantPoolAnnoAttrributes = null;
            this.currentClass = null;
            this.classAnnotations = null;
            this.internPool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index complete() {
        this.initIndexMaps();
        try {
            Index index = Index.create(this.masterAnnotations, this.subclasses, this.implementors, this.classes);
            return index;
        }
        finally {
            this.masterAnnotations = null;
            this.subclasses = null;
            this.classes = null;
        }
    }

    private static class IntegerHolder {
        private int i;

        private IntegerHolder() {
        }
    }
}

