/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Map;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class ValidationImpl
extends org.jboss.jca.common.metadata.common.ValidationImpl
implements Validation {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);
    private Extension validConnectionChecker;
    private String checkValidConnectionSql;
    private Extension staleConnectionChecker;
    private Extension exceptionSorter;

    public ValidationImpl(Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail, Extension validConnectionChecker, String checkValidConnectionSql, Boolean validateOnMatch, Extension staleConnectionChecker, Extension exceptionSorter) throws ValidateException {
        super(validateOnMatch, backgroundValidation, backgroundValidationMillis, useFastFail);
        this.validConnectionChecker = validConnectionChecker;
        this.checkValidConnectionSql = checkValidConnectionSql;
        this.staleConnectionChecker = staleConnectionChecker;
        this.exceptionSorter = exceptionSorter;
        this.validate();
    }

    @Override
    public String getCheckValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    @Override
    public Extension getValidConnectionChecker() {
        return this.validConnectionChecker;
    }

    @Override
    public Extension getStaleConnectionChecker() {
        return this.staleConnectionChecker;
    }

    @Override
    public Extension getExceptionSorter() {
        return this.exceptionSorter;
    }

    @Override
    public void validate() throws ValidateException {
        if (this.backgroundValidationMillis != null && this.backgroundValidationMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(Validation.Tag.BACKGROUND_VALIDATION_MILLIS.getLocalName()));
        }
        if (this.validConnectionChecker != null) {
            try {
                this.validConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.VALID_CONNECTION_CHECKER.getLocalName()), ve);
            }
        }
        if (this.exceptionSorter != null) {
            try {
                this.exceptionSorter.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.EXCEPTION_SORTER.getLocalName()), ve);
            }
        }
        if (this.staleConnectionChecker != null) {
            try {
                this.staleConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag(Validation.Tag.STALE_CONNECTION_CHECKER.getLocalName()), ve);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<validation>");
        if (this.validConnectionChecker != null) {
            sb.append("<").append((Object)Validation.Tag.VALID_CONNECTION_CHECKER);
            sb.append(" ").append((Object)Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.validConnectionChecker.getClassName()).append("\"");
            sb.append(">");
            if (this.validConnectionChecker.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry<String, String> entry : this.validConnectionChecker.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append((Object)Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append(entry.getKey()).append("\">");
                    sb.append(entry.getValue());
                    sb.append("</").append((Object)Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append((Object)Validation.Tag.VALID_CONNECTION_CHECKER).append(">");
        }
        if (this.checkValidConnectionSql != null) {
            sb.append("<").append((Object)Validation.Tag.CHECK_VALID_CONNECTION_SQL).append(">");
            sb.append(this.checkValidConnectionSql);
            sb.append("</").append((Object)Validation.Tag.CHECK_VALID_CONNECTION_SQL).append(">");
        }
        if (this.validateOnMatch != null) {
            sb.append("<").append((Object)Validation.Tag.VALIDATE_ON_MATCH).append(">");
            sb.append(this.validateOnMatch);
            sb.append("</").append((Object)Validation.Tag.VALIDATE_ON_MATCH).append(">");
        }
        if (this.backgroundValidation != null) {
            sb.append("<").append((Object)Validation.Tag.BACKGROUND_VALIDATION).append(">");
            sb.append(this.backgroundValidation);
            sb.append("</").append((Object)Validation.Tag.BACKGROUND_VALIDATION).append(">");
        }
        if (this.backgroundValidationMillis != null) {
            sb.append("<").append((Object)Validation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
            sb.append(this.backgroundValidationMillis);
            sb.append("</").append((Object)Validation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
        }
        if (this.useFastFail != null) {
            sb.append("<").append((Object)Validation.Tag.USE_FAST_FAIL).append(">");
            sb.append(this.useFastFail);
            sb.append("</").append((Object)Validation.Tag.USE_FAST_FAIL).append(">");
        }
        if (this.staleConnectionChecker != null) {
            sb.append("<").append((Object)Validation.Tag.STALE_CONNECTION_CHECKER);
            sb.append(" ").append((Object)Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.staleConnectionChecker.getClassName()).append("\"");
            sb.append(">");
            if (this.staleConnectionChecker.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry<String, String> entry : this.staleConnectionChecker.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append((Object)Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append(entry.getKey()).append("\">");
                    sb.append(entry.getValue());
                    sb.append("</").append((Object)Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append((Object)Validation.Tag.STALE_CONNECTION_CHECKER).append(">");
        }
        if (this.exceptionSorter != null) {
            sb.append("<").append((Object)Validation.Tag.EXCEPTION_SORTER);
            sb.append(" ").append((Object)Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.exceptionSorter.getClassName()).append("\"");
            sb.append(">");
            if (this.exceptionSorter.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry<String, String> entry : this.exceptionSorter.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append((Object)Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append(entry.getKey()).append("\">");
                    sb.append(entry.getValue());
                    sb.append("</").append((Object)Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append((Object)Validation.Tag.EXCEPTION_SORTER).append(">");
        }
        sb.append("</validation>");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checkValidConnectionSql == null ? 0 : this.checkValidConnectionSql.hashCode());
        result = 31 * result + (this.exceptionSorter == null ? 0 : this.exceptionSorter.hashCode());
        result = 31 * result + (this.staleConnectionChecker == null ? 0 : this.staleConnectionChecker.hashCode());
        result = 31 * result + (this.validConnectionChecker == null ? 0 : this.validConnectionChecker.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ValidationImpl)) {
            return false;
        }
        ValidationImpl other = (ValidationImpl)obj;
        if (this.checkValidConnectionSql == null ? other.checkValidConnectionSql != null : !this.checkValidConnectionSql.equals(other.checkValidConnectionSql)) {
            return false;
        }
        if (this.exceptionSorter == null ? other.exceptionSorter != null : !this.exceptionSorter.equals(other.exceptionSorter)) {
            return false;
        }
        if (this.staleConnectionChecker == null ? other.staleConnectionChecker != null : !this.staleConnectionChecker.equals(other.staleConnectionChecker)) {
            return false;
        }
        return !(this.validConnectionChecker == null ? other.validConnectionChecker != null : !this.validConnectionChecker.equals(other.validConnectionChecker));
    }
}

