/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.spec.MergeableMetadata;
import org.jboss.jca.common.api.metadata.spec.MessageListener;
import org.jboss.jca.common.api.metadata.spec.Messageadapter;

public class MessageAdapterImpl
implements Messageadapter {
    private static final long serialVersionUID = 1L;
    private List<MessageListener> messagelisteners;
    private String id;

    public MessageAdapterImpl(List<MessageListener> messagelisteners, String id) {
        this.messagelisteners = messagelisteners != null ? new ArrayList<MessageListener>(messagelisteners) : new ArrayList<MessageListener>(0);
        this.id = id;
    }

    @Override
    public List<MessageListener> getMessagelisteners() {
        return Collections.unmodifiableList(this.messagelisteners);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Messageadapter merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof MessageAdapterImpl) {
            MessageAdapterImpl input = (MessageAdapterImpl)jmd;
            String newId = this.id == null ? input.id : this.id;
            List<MessageListener> newMessagelistener = MergeUtil.mergeList(this.messagelisteners, input.messagelisteners);
            return new MessageAdapterImpl(newMessagelistener, newId);
        }
        return this;
    }

    @Override
    public CopyableMetaData copy() {
        return new MessageAdapterImpl(CopyUtil.cloneList(this.messagelisteners), CopyUtil.cloneString(this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.messagelisteners == null ? 0 : this.messagelisteners.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAdapterImpl)) {
            return false;
        }
        MessageAdapterImpl other = (MessageAdapterImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.messagelisteners == null ? other.messagelisteners != null : !this.messagelisteners.equals(other.messagelisteners));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<messageadapter");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.messagelisteners != null) {
            for (MessageListener ml : this.messagelisteners) {
                sb.append(ml);
            }
        }
        sb.append("</messageadapter>");
        return sb.toString();
    }
}

