/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata;

import java.util.logging.Logger;
import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataEnum;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataUtil {
    private static final Logger log = Logger.getLogger(MetadataUtil.class.getName());
    private static final char NEWLINE = '\n';
    private static final String LINE = "--------------------------------------------";

    public static String getAttributeValue(Element element, String name) {
        Node node = element.getAttributes().getNamedItem(name);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    public static Node getNextParentNodeWithAttr(Node parent, String attrName) {
        Node parentNode = parent;
        Element parendElement = (Element)parentNode;
        Node valueNode = parendElement.getAttributes().getNamedItem(attrName);
        while (valueNode == null && (parentNode = parentNode.getParentNode()) != null) {
            if (parentNode.getNodeType() != 1) continue;
            parendElement = (Element)parentNode;
            valueNode = parendElement.getAttributes().getNamedItem(attrName);
        }
        return parendElement;
    }

    public static boolean hasChildOf(Element parentElement, XsdElementEnum child) {
        NodeList nodeList = parentElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement;
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !child.isTagNameEqual((childElement = (Element)childNode).getTagName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChildsOf(Element parentElement, XsdElementEnum child) {
        NodeList nodeList = parentElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            if (child.isTagNameEqual(childElement.getTagName())) {
                return true;
            }
            if (!childElement.hasChildNodes() || !MetadataUtil.hasChildsOf(childElement, child)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParentOf(Element parentElement, XsdElementEnum parentEnum) {
        for (Node parent = parentElement.getParentNode(); parent != null; parent = parent.getParentNode()) {
            Element parentElm;
            if (parent.getNodeType() != 1 || !parentEnum.isTagNameEqual((parentElm = (Element)parent).getTagName())) continue;
            return true;
        }
        return false;
    }

    public void log(Metadata metadata) {
        StringBuilder sb = new StringBuilder();
        for (MetadataItem item : metadata.getGroupList()) {
            sb.append(LINE);
            sb.append('\n');
            sb.append(LINE);
            sb.append("Group: " + item.getName());
            sb.append('\n');
            for (MetadataElement element : item.getElements()) {
                sb.append("  Element  : " + element.getName());
                sb.append('\n');
                sb.append("  Type     : " + element.getType());
                sb.append('\n');
                sb.append("  MinOccurs: " + element.getMinOccurs());
                sb.append('\n');
                sb.append("  MaxOccurs: " + element.getMaxOccurs());
                sb.append('\n');
                sb.append("  IsAttr   : " + element.getIsAttribute());
                sb.append('\n');
                sb.append('\n');
            }
            for (MetadataElement element : item.getReferences()) {
                sb.append("  Ref      : " + element.getRef());
                sb.append('\n');
            }
            sb.append('\n');
        }
        for (MetadataEnum enumItem : metadata.getEnumList()) {
            sb.append(LINE);
            sb.append('\n');
            sb.append("Enum: " + enumItem.getName());
            sb.append('\n');
            for (String enumValue : enumItem.getValueList()) {
                sb.append("  Value    : " + enumValue);
                sb.append('\n');
            }
            sb.append('\n');
        }
        for (MetadataItem item : metadata.getClassList()) {
            sb.append(LINE);
            sb.append('\n');
            sb.append("Class: " + item.getName());
            sb.append('\n');
            for (MetadataElement element : item.getElements()) {
                sb.append("  Element  : " + element.getName());
                sb.append('\n');
                sb.append("  Type     : " + element.getType());
                sb.append('\n');
                sb.append("  MinOccurs: " + element.getMinOccurs());
                sb.append('\n');
                sb.append("  MaxOccurs: " + element.getMaxOccurs());
                sb.append('\n');
                sb.append("  IsAttr   : " + element.getIsAttribute());
                sb.append('\n');
                sb.append('\n');
            }
            for (MetadataElement element : item.getReferences()) {
                sb.append("  Ref      : " + element.getRef());
                sb.append('\n');
            }
            sb.append('\n');
        }
        for (MetadataItem dataType : metadata.getDataTypeList()) {
            sb.append(LINE);
            sb.append('\n');
            sb.append("Name    : " + dataType.getName());
            sb.append('\n');
            sb.append("MappedTo: " + dataType.getMappedTo());
            sb.append('\n');
        }
        log.info(sb.toString());
    }
}

