/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.filter;

import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataUtil;
import org.jboss.shrinkwrap.descriptor.metadata.filter.Filter;
import org.jboss.shrinkwrap.descriptor.metadata.filter.XsdElementEnum;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class ComplexTypeFilter
implements Filter {
    public boolean filter(Metadata metadata, TreeWalker walker) {
        Node parent = walker.getCurrentNode();
        Element element = (Element)parent;
        if (XsdElementEnum.complexType.isTagNameEqual(element.getTagName())) {
            String typeStr = MetadataUtil.getAttributeValue(element, "type");
            String mixedStr = MetadataUtil.getAttributeValue(element, "mixed");
            String abstractStr = MetadataUtil.getAttributeValue(element, "abstract");
            if (typeStr == null && !element.hasChildNodes()) {
                String dataTypeName = MetadataUtil.getAttributeValue(element, "name");
                MetadataItem dataType = new MetadataItem(dataTypeName);
                dataType.setMappedTo("javaee:emptyType");
                dataType.setNamespace(metadata.getCurrentNamespace());
                dataType.setSchemaName(metadata.getCurrentSchmema());
                metadata.getDataTypeList().add(dataType);
                return true;
            }
            if (mixedStr != null && mixedStr.equals("true")) {
                String complexTypeName = MetadataUtil.getAttributeValue(element, "name");
                MetadataElement classElement = new MetadataElement();
                classElement.setName(complexTypeName);
                classElement.setType("text");
                classElement.setIsRef(false);
                classElement.setIsAttribute(false);
                metadata.addClassElement(complexTypeName, classElement);
            } else if (abstractStr != null && abstractStr.equals("true")) {
                String complexTypeName = MetadataUtil.getAttributeValue(element, "name");
                MetadataElement classElement = new MetadataElement();
                classElement.setName(complexTypeName);
                classElement.setType(metadata.getCurrentNamespace() + ":" + complexTypeName);
                classElement.setIsRef(false);
                classElement.setIsAttribute(false);
                metadata.addClassElement(complexTypeName, classElement);
            } else if (!(MetadataUtil.hasChildOf(element, XsdElementEnum.simpleContent) || MetadataUtil.hasChildOf(element, XsdElementEnum.complexContent) || MetadataUtil.hasChildOf(element, XsdElementEnum.group) || MetadataUtil.hasChildOf(element, XsdElementEnum.all) || MetadataUtil.hasChildOf(element, XsdElementEnum.choice) || MetadataUtil.hasChildOf(element, XsdElementEnum.sequence) || MetadataUtil.hasChildOf(element, XsdElementEnum.attribute) || MetadataUtil.hasChildOf(element, XsdElementEnum.attributeGroup) || MetadataUtil.hasChildOf(element, XsdElementEnum.anyAttribute))) {
                String dataTypeName = MetadataUtil.getAttributeValue(element, "name");
                MetadataItem dataType = new MetadataItem(dataTypeName);
                dataType.setMappedTo("javaee:emptyType");
                dataType.setNamespace(metadata.getCurrentNamespace());
                dataType.setSchemaName(metadata.getCurrentSchmema());
                metadata.getDataTypeList().add(dataType);
                return true;
            }
        }
        return false;
    }
}

