/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.jar.Attributes;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExportException;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestCommonDef;
import org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest.ManifestModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ManifestCommonDefImpl<T>
implements ManifestCommonDef<T> {
    ManifestCommonDefImpl() {
    }

    abstract T getDescriptor();

    abstract ManifestModel getManifestModel();

    abstract void includeAttribute(Attributes.Name var1, String var2);

    abstract String findAttribute(Attributes.Name var1);

    void includeAttribute(String name, String value) {
        this.includeAttribute(new Attributes.Name(name), value);
    }

    @Override
    public T version(String version) {
        this.includeAttribute(Attributes.Name.MANIFEST_VERSION, version);
        return this.getDescriptor();
    }

    @Override
    public T signatureVersion(String version) {
        this.includeAttribute(Attributes.Name.SIGNATURE_VERSION, version);
        return this.getDescriptor();
    }

    @Override
    public T mainClass(String mainClass) {
        this.includeAttribute(Attributes.Name.MAIN_CLASS, mainClass);
        return this.getDescriptor();
    }

    @Override
    public T implementationTitle(String title) {
        this.includeAttribute(Attributes.Name.IMPLEMENTATION_TITLE, title);
        return this.getDescriptor();
    }

    @Override
    public T implementationVendor(String vendor) {
        this.includeAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, vendor);
        return this.getDescriptor();
    }

    @Override
    public T implementationVendorId(String vendorId) {
        this.includeAttribute(Attributes.Name.IMPLEMENTATION_VENDOR_ID, vendorId);
        return this.getDescriptor();
    }

    @Override
    public T implementationUrl(String url) {
        this.includeAttribute(Attributes.Name.IMPLEMENTATION_URL, url);
        return this.getDescriptor();
    }

    @Override
    public T specificationTitle(String title) {
        this.includeAttribute(Attributes.Name.SPECIFICATION_TITLE, title);
        return this.getDescriptor();
    }

    @Override
    public T specificationVersion(String version) {
        this.includeAttribute(Attributes.Name.SPECIFICATION_VERSION, version);
        return this.getDescriptor();
    }

    @Override
    public T specificationVendor(String vendor) {
        this.includeAttribute(Attributes.Name.SPECIFICATION_VENDOR, vendor);
        return this.getDescriptor();
    }

    @Override
    public T sealed() {
        this.includeAttribute(Attributes.Name.SEALED, TRUE);
        return this.getDescriptor();
    }

    @Override
    public T notSealed() {
        this.includeAttribute(Attributes.Name.SEALED, FALSE);
        return this.getDescriptor();
    }

    @Override
    public T createdBy(String creator) {
        this.includeAttribute(CREATED_BY, creator);
        return this.getDescriptor();
    }

    @Override
    public T addToClassPath(String value) {
        String classpath = this.findAttribute(Attributes.Name.CLASS_PATH);
        String newClasspath = value;
        if (classpath != null) {
            newClasspath = classpath + " " + newClasspath;
        }
        this.includeAttribute(Attributes.Name.CLASS_PATH, newClasspath);
        return this.getDescriptor();
    }

    @Override
    public T attribute(String name, String value) {
        this.includeAttribute(name, value);
        return this.getDescriptor();
    }

    @Override
    public T implementationVersion(String vendor) {
        this.includeAttribute(Attributes.Name.IMPLEMENTATION_VERSION, vendor);
        return this.getDescriptor();
    }

    @Override
    public final String exportAsString() throws DescriptorExportException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.exportTo(baos);
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DescriptorExportException("Inconsistent encoding used during export", e);
        }
    }

    @Override
    public void exportTo(OutputStream output) throws DescriptorExportException, IllegalArgumentException {
        if (output == null) {
            throw new IllegalArgumentException("Can not export to null stream");
        }
        try {
            this.getManifestModel().write(output);
        }
        catch (IOException e) {
            throw new DescriptorExportException(e.getMessage(), e);
        }
    }
}

