/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.Map;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.generator.model.MessageBundleImplementor;
import org.jboss.logging.processor.generator.model.MessageBundleTranslator;
import org.jboss.logging.processor.generator.model.MessageLoggerImplementor;
import org.jboss.logging.processor.generator.model.MessageLoggerTranslator;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.TranslationHelper;

public class ClassModelFactory {
    private ClassModelFactory() {
    }

    public static ClassModel implementation(MessageInterface messageInterface, boolean useLogging31) throws IllegalArgumentException {
        if (messageInterface.isMessageBundle()) {
            return new MessageBundleImplementor(messageInterface);
        }
        if (messageInterface.isMessageLogger()) {
            return new MessageLoggerImplementor(messageInterface, useLogging31);
        }
        throw new IllegalArgumentException(String.format("Message interface %s is not a valid message logger or message bundle.", messageInterface));
    }

    public static ClassModel translation(MessageInterface messageInterface, String translationSuffix, Map<MessageMethod, String> translations) throws IllegalArgumentException {
        String generatedClassName = ClassModelHelper.implementationClassName(messageInterface, translationSuffix);
        String superClassName = TranslationHelper.getEnclosingTranslationClassName(generatedClassName);
        if (messageInterface.isMessageBundle()) {
            return new MessageBundleTranslator(messageInterface, generatedClassName, superClassName, translations);
        }
        if (messageInterface.isMessageLogger()) {
            return new MessageLoggerTranslator(messageInterface, generatedClassName, superClassName, translations);
        }
        throw new IllegalArgumentException(String.format("Message interface %s is not a valid message logger or message bundle.", messageInterface));
    }
}

