/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.spec.XML;

public class ConfigPropertyImpl
implements ConfigProperty {
    private static final long serialVersionUID = 1L;
    private List<LocalizedXsdString> description;
    private XsdString configPropertyName;
    private XsdString configPropertyType;
    private XsdString configPropertyValue;
    private Boolean configPropertyIgnore;
    private Boolean configPropertySupportsDynamicUpdates;
    private Boolean configPropertyConfidential;
    private String id;
    private boolean mandatory;
    private String configPropertyIgnoreId;
    private String configPropertySupportsDynamicUpdatesId;
    private String configPropertyConfidentialId;
    private String attachedClassName;

    public ConfigPropertyImpl(List<LocalizedXsdString> description, XsdString configPropertyName, XsdString configPropertyType, XsdString configPropertyValue, Boolean configPropertyIgnore, Boolean configPropertySupportsDynamicUpdates, Boolean configPropertyConfidential, String id, boolean mandatory, String attachedClassName, String configPropertyIgnoreId, String configPropertySupportsDynamicUpdatesId, String configPropertyConfidentialId) {
        if (description != null) {
            this.description = new ArrayList<LocalizedXsdString>(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag(XML.ConfigPropertyTag.DESCRIPTION.toString());
            }
        } else {
            this.description = new ArrayList<LocalizedXsdString>(0);
        }
        this.configPropertyName = configPropertyName;
        if (!XsdString.isNull(this.configPropertyName)) {
            this.configPropertyName.setTag(XML.ConfigPropertyTag.CONFIG_PROPERTY_NAME.toString());
        }
        this.configPropertyType = configPropertyType;
        if (!XsdString.isNull(this.configPropertyType)) {
            this.configPropertyType.setTag(XML.ConfigPropertyTag.CONFIG_PROPERTY_TYPE.toString());
        }
        this.configPropertyValue = configPropertyValue;
        if (!XsdString.isNull(this.configPropertyValue)) {
            this.configPropertyValue.setTag(XML.ConfigPropertyTag.CONFIG_PROPERTY_VALUE.toString());
        }
        this.configPropertyIgnore = configPropertyIgnore;
        this.configPropertySupportsDynamicUpdates = configPropertySupportsDynamicUpdates;
        this.configPropertyConfidential = configPropertyConfidential;
        this.id = id;
        this.mandatory = mandatory;
        this.attachedClassName = attachedClassName;
        this.configPropertyIgnoreId = configPropertyIgnoreId;
        this.configPropertyConfidentialId = configPropertyConfidentialId;
        this.configPropertySupportsDynamicUpdatesId = configPropertySupportsDynamicUpdatesId;
    }

    @Override
    public String getAttachedClassName() {
        return this.attachedClassName;
    }

    @Override
    public Boolean getConfigPropertyIgnore() {
        return this.configPropertyIgnore;
    }

    @Override
    public Boolean getConfigPropertySupportsDynamicUpdates() {
        return this.configPropertySupportsDynamicUpdates;
    }

    @Override
    public Boolean getConfigPropertyConfidential() {
        return this.configPropertyConfidential;
    }

    @Override
    public String getConfigPropertyIgnoreId() {
        return this.configPropertyIgnoreId;
    }

    @Override
    public String getConfigPropertyConfidentialId() {
        return this.configPropertyConfidentialId;
    }

    @Override
    public String getConfigPropertySupportsDynamicUpdatesId() {
        return this.configPropertySupportsDynamicUpdatesId;
    }

    @Override
    public List<LocalizedXsdString> getDescriptions() {
        return Collections.unmodifiableList(this.description);
    }

    @Override
    public XsdString getConfigPropertyName() {
        return this.configPropertyName;
    }

    @Override
    public XsdString getConfigPropertyType() {
        return this.configPropertyType;
    }

    @Override
    public XsdString getConfigPropertyValue() {
        return this.configPropertyValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValueSet() {
        return this.getConfigPropertyValue() != null && this.getConfigPropertyValue().getValue() != null && !this.getConfigPropertyValue().getValue().trim().equals("");
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean v) {
        this.mandatory = v;
    }

    @Override
    public CopyableMetaData copy() {
        return new ConfigPropertyImpl(CopyUtil.cloneList(this.description), CopyUtil.clone(this.configPropertyName), CopyUtil.clone(this.configPropertyType), CopyUtil.clone(this.configPropertyValue), this.configPropertyIgnore, this.configPropertySupportsDynamicUpdates, this.configPropertyConfidential, CopyUtil.cloneString(this.id), this.mandatory, CopyUtil.cloneString(this.attachedClassName), CopyUtil.cloneString(this.configPropertyIgnoreId), CopyUtil.cloneString(this.configPropertySupportsDynamicUpdatesId), CopyUtil.cloneString(this.configPropertyConfidentialId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configPropertyName == null ? 0 : this.configPropertyName.hashCode());
        result = 31 * result + (this.configPropertyType == null ? 0 : this.configPropertyType.hashCode());
        result = 31 * result + (this.configPropertyValue == null ? 0 : this.configPropertyValue.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.mandatory ? 7 : 0);
        result = 31 * result + (this.attachedClassName == null ? 0 : this.attachedClassName.hashCode());
        result = 31 * result + (this.configPropertyConfidential == null ? 0 : this.configPropertyConfidential.hashCode());
        result = 31 * result + (this.configPropertyIgnore == null ? 0 : this.configPropertyIgnore.hashCode());
        result = 31 * result + (this.configPropertySupportsDynamicUpdates == null ? 0 : this.configPropertySupportsDynamicUpdates.hashCode());
        result = 31 * result + (this.configPropertyIgnoreId == null ? 0 : this.configPropertyIgnoreId.hashCode());
        result = 31 * result + (this.configPropertySupportsDynamicUpdatesId == null ? 0 : this.configPropertySupportsDynamicUpdatesId.hashCode());
        result = 31 * result + (this.configPropertyConfidentialId == null ? 0 : this.configPropertyConfidentialId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigPropertyImpl)) {
            return false;
        }
        ConfigPropertyImpl other = (ConfigPropertyImpl)obj;
        if (this.configPropertyName == null ? other.configPropertyName != null : !this.configPropertyName.equals(other.configPropertyName)) {
            return false;
        }
        if (this.configPropertyType == null ? other.configPropertyType != null : !this.configPropertyType.equals(other.configPropertyType)) {
            return false;
        }
        if (this.configPropertyValue == null ? other.configPropertyValue != null : !this.configPropertyValue.equals(other.configPropertyValue)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.mandatory != other.mandatory) {
            return false;
        }
        if (this.attachedClassName == null ? other.attachedClassName != null : !this.attachedClassName.equals(other.attachedClassName)) {
            return false;
        }
        if (this.configPropertyConfidential == null ? other.configPropertyConfidential != null : !this.configPropertyConfidential.equals(other.configPropertyConfidential)) {
            return false;
        }
        if (this.configPropertyIgnore == null ? other.configPropertyIgnore != null : !this.configPropertyIgnore.equals(other.configPropertyIgnore)) {
            return false;
        }
        if (this.configPropertySupportsDynamicUpdates == null ? other.configPropertySupportsDynamicUpdates != null : !this.configPropertySupportsDynamicUpdates.equals(other.configPropertySupportsDynamicUpdates)) {
            return false;
        }
        if (this.configPropertyIgnoreId == null ? other.configPropertyIgnoreId != null : !this.configPropertyIgnoreId.equals(other.configPropertyIgnoreId)) {
            return false;
        }
        if (this.configPropertySupportsDynamicUpdatesId == null ? other.configPropertySupportsDynamicUpdatesId != null : !this.configPropertySupportsDynamicUpdatesId.equals(other.configPropertySupportsDynamicUpdatesId)) {
            return false;
        }
        return !(this.configPropertyConfidentialId == null ? other.configPropertyConfidentialId != null : !this.configPropertyConfidentialId.equals(other.configPropertyConfidentialId));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<config-property");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        for (LocalizedXsdString d : this.description) {
            sb.append(d);
        }
        sb.append(this.configPropertyName);
        sb.append(this.configPropertyType);
        if (!XsdString.isNull(this.configPropertyValue)) {
            sb.append(this.configPropertyValue);
        }
        if (this.configPropertyIgnore != null) {
            sb.append("<").append((Object)XML.ConfigPropertyTag.CONFIG_PROPERTY_IGNORE).append((String)(this.configPropertyIgnoreId == null ? "" : " id=\"" + this.configPropertyIgnoreId + "\"")).append(">");
            sb.append(this.configPropertyIgnore);
            sb.append("</").append((Object)XML.ConfigPropertyTag.CONFIG_PROPERTY_IGNORE).append(">");
        }
        if (this.configPropertySupportsDynamicUpdates != null) {
            sb.append("<").append((Object)XML.ConfigPropertyTag.CONFIG_PROPERTY_SUPPORT_DYNAMIC_UPDATE).append((String)(this.configPropertySupportsDynamicUpdatesId == null ? "" : " id=\"" + this.configPropertySupportsDynamicUpdatesId + "\"")).append(">");
            sb.append(this.configPropertySupportsDynamicUpdates);
            sb.append("</").append((Object)XML.ConfigPropertyTag.CONFIG_PROPERTY_SUPPORT_DYNAMIC_UPDATE).append(">");
        }
        if (this.configPropertyConfidential != null) {
            sb.append("<").append((Object)XML.ConfigPropertyTag.CONFIG_PROPERTY_CONFIDENTIAL).append((String)(this.configPropertyConfidentialId == null ? "" : " id=\"" + this.configPropertyConfidentialId + "\"")).append(">");
            sb.append(this.configPropertyConfidential);
            sb.append("</").append((Object)XML.ConfigPropertyTag.CONFIG_PROPERTY_CONFIDENTIAL).append(">");
        }
        sb.append("</config-property>");
        return sb.toString();
    }
}

