/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.AbstractParser;
import org.jboss.jca.common.metadata.ds.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.DatasourcesImpl;
import org.jboss.jca.common.metadata.ds.DriverImpl;
import org.jboss.jca.common.metadata.ds.DsPoolImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.DsXaPoolImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;

public class DsParser
extends AbstractParser
implements MetadataParser<DataSources> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSources parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        try {
            DataSources dataSources = this.parse(reader);
            return dataSources;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public DataSources parse(XMLStreamReader reader) throws Exception {
        int iterate;
        DataSources dataSources = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        dataSources = this.parseDataSources(reader);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return dataSources;
    }

    protected DataSources parseDataSources(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<DataSource> datasource = new ArrayList<DataSource>();
        ArrayList<XaDataSource> xaDataSource = new ArrayList<XaDataSource>();
        HashMap<String, Driver> drivers = new HashMap<String, Driver>();
        boolean driversMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.DATASOURCES) {
                        return new DatasourcesImpl(datasource, xaDataSource, drivers);
                    }
                    if (DataSources.Tag.forName(reader.getLocalName()) != DataSources.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSources.Tag.forName(reader.getLocalName())) {
                        case DATASOURCE: {
                            datasource.add(this.parseDataSource(reader));
                            break block0;
                        }
                        case XA_DATASOURCE: {
                            xaDataSource.add(this.parseXADataSource(reader));
                            break block0;
                        }
                        case DRIVERS: {
                            driversMatched = true;
                            break block0;
                        }
                        case DRIVER: {
                            Driver driver = this.parseDriver(reader);
                            drivers.put(driver.getName(), driver);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Driver parseDriver(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String driverClass = null;
        String dataSourceClass = null;
        String xaDataSourceClass = null;
        String name = null;
        Integer majorVersion = null;
        Integer minorVersion = null;
        String module = null;
        block15: for (Driver.Attribute attribute : Driver.Attribute.values()) {
            switch (attribute) {
                case NAME: {
                    name = this.attributeAsString(reader, attribute.getLocalName());
                    continue block15;
                }
                case MAJOR_VERSION: {
                    majorVersion = this.attributeAsInt(reader, attribute.getLocalName());
                    continue block15;
                }
                case MINOR_VERSION: {
                    minorVersion = this.attributeAsInt(reader, attribute.getLocalName());
                    continue block15;
                }
                case MODULE: {
                    module = this.attributeAsString(reader, attribute.getLocalName());
                    continue block15;
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName(reader.getLocalName()) == DataSources.Tag.DRIVER) {
                        return new DriverImpl(name, majorVersion, minorVersion, module, driverClass, dataSourceClass, xaDataSourceClass);
                    }
                    if (Driver.Tag.forName(reader.getLocalName()) != Driver.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Driver.Tag.forName(reader.getLocalName())) {
                        case DATASOURCE_CLASS: {
                            dataSourceClass = this.elementAsString(reader);
                            break block6;
                        }
                        case XA_DATASOURCE_CLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block6;
                        }
                        case DRIVER_CLASS: {
                            driverClass = this.elementAsString(reader);
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DsSecurity parseDsSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        Extension reauthPlugin = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName(reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new DsSecurityImpl(userName, password, securityDomain, reauthPlugin);
                    }
                    if (DsSecurity.Tag.forName(reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName(reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            reauthPlugin = this.parseExtension(reader, tag.getLocalName());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Validation parseValidationSetting(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Boolean validateOnMatch = Defaults.VALIDATE_ON_MATCH;
        Boolean useFastFail = Defaults.USE_CCM;
        Long backgroundValidationMillis = null;
        Extension staleConnectionChecker = null;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        String checkValidConnectionSql = null;
        Extension validConnectionChecker = null;
        Extension exceptionSorter = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName(reader.getLocalName()) == DataSource.Tag.VALIDATION) {
                        return new ValidationImpl(backgroundValidation, backgroundValidationMillis, useFastFail, validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
                    }
                    if (Validation.Tag.forName(reader.getLocalName()) != Validation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    Validation.Tag currTag = Validation.Tag.forName(reader.getLocalName());
                    switch (currTag) {
                        case BACKGROUND_VALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            backgroundValidationMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case CHECK_VALID_CONNECTION_SQL: {
                            checkValidConnectionSql = this.elementAsString(reader);
                            break block0;
                        }
                        case EXCEPTION_SORTER: {
                            exceptionSorter = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                        case STALE_CONNECTION_CHECKER: {
                            staleConnectionChecker = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            validateOnMatch = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case VALID_CONNECTION_CHECKER: {
                            validConnectionChecker = this.parseExtension(reader, currTag.getLocalName());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected TimeOut parseTimeOutSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        Boolean setTxQuertTimeout = Defaults.SET_TX_QUERY_TIMEOUT;
        Long queryTimeout = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Long useTryLock = null;
        Integer xaResourceTimeout = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName(reader.getLocalName()) == DataSource.Tag.TIMEOUT) {
                        return new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQuertTimeout, queryTimeout, useTryLock);
                    }
                    if (TimeOut.Tag.forName(reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (TimeOut.Tag.forName(reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case QUERY_TIMEOUT: {
                            queryTimeout = this.elementAsLong(reader);
                            break block0;
                        }
                        case SET_TX_QUERY_TIMEOUT: {
                            setTxQuertTimeout = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_TRY_LOCK: {
                            useTryLock = this.elementAsLong(reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            xaResourceTimeout = this.elementAsInteger(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Statement parseStatementSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long preparedStatementsCacheSize = null;
        Boolean sharePreparedStatements = Defaults.SHARE_PREPARED_STATEMENTS;
        Statement.TrackStatementsEnum trackStatements = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName(reader.getLocalName()) == DataSource.Tag.STATEMENT) {
                        return new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
                    }
                    if (Statement.Tag.forName(reader.getLocalName()) != Statement.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Statement.Tag.forName(reader.getLocalName())) {
                        case PREPARED_STATEMENT_CACHE_SIZE: {
                            preparedStatementsCacheSize = this.elementAsLong(reader);
                            break block0;
                        }
                        case TRACK_STATEMENTS: {
                            String elementString = this.elementAsString(reader);
                            trackStatements = Statement.TrackStatementsEnum.valueOf(elementString == null ? "FALSE" : elementString.toUpperCase(Locale.US));
                            break block0;
                        }
                        case SHARE_PREPARED_STATEMENTS: {
                            sharePreparedStatements = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected DsPool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Boolean allowMultipleUsers = Defaults.ALLOW_MULTIPLE_USERS;
        Capacity capacity = null;
        Boolean fair = Defaults.FAIR;
        Extension connectionListener = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName(reader.getLocalName()) == DataSource.Tag.POOL) {
                        return new DsPoolImpl(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, allowMultipleUsers, capacity, fair, connectionListener);
                    }
                    if (DsPool.Tag.forName(reader.getLocalName()) != DsPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsPool.Tag tag = DsPool.Tag.forName(reader.getLocalName());
                    switch (tag) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            initialPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FAIR: {
                            fair = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            allowMultipleUsers = Boolean.TRUE;
                            break block0;
                        }
                        case CAPACITY: {
                            capacity = this.parseCapacity(reader);
                            break block0;
                        }
                        case CONNECTION_LISTENER: {
                            connectionListener = this.parseExtension(reader, tag.getLocalName());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected DsXaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Boolean allowMultipleUsers = Defaults.ALLOW_MULTIPLE_USERS;
        Capacity capacity = null;
        Boolean fair = Defaults.FAIR;
        Extension connectionListener = null;
        Boolean interleaving = Defaults.INTERLEAVING;
        Boolean isSameRmOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean padXid = Defaults.PAD_XID;
        Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
        Boolean wrapXaDataSource = Defaults.WRAP_XA_RESOURCE;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName(reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return new DsXaPoolImpl(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaDataSource, noTxSeparatePool, allowMultipleUsers, capacity, fair, connectionListener);
                    }
                    if (DsXaPool.Tag.forName(reader.getLocalName()) != DsXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsXaPool.Tag tag = DsXaPool.Tag.forName(reader.getLocalName());
                    switch (tag) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            initialPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            interleaving = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            isSameRmOverride = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PAD_XID: {
                            padXid = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            wrapXaDataSource = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FAIR: {
                            fair = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            allowMultipleUsers = Boolean.TRUE;
                            break block0;
                        }
                        case CAPACITY: {
                            capacity = this.parseCapacity(reader);
                            break block0;
                        }
                        case CONNECTION_LISTENER: {
                            connectionListener = this.parseExtension(reader, tag.getLocalName());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected XaDataSource parseXADataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlProperty = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsXaPool xaPool = null;
        Recovery recovery = null;
        String xaDataSourceClass = null;
        String driver = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        String mcp = Defaults.MCP;
        Boolean enlistmentTrace = Defaults.ENLISTMENT_TRACE;
        block32: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENABLED);
                    continue block32;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block32;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block32;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_JAVA_CONTEXT);
                    continue block32;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.SPY);
                    continue block32;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_CCM);
                    continue block32;
                }
                case CONNECTABLE: {
                    connectable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.CONNECTABLE);
                    continue block32;
                }
                case TRACKING: {
                    tracking = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.TRACKING);
                    continue block32;
                }
                case MCP: {
                    mcp = this.attributeAsString(reader, attribute.getLocalName());
                    continue block32;
                }
                case ENLISTMENT_TRACE: {
                    enlistmentTrace = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENLISTMENT_TRACE);
                    continue block32;
                }
            }
        }
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName(reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        return new XADataSourceImpl(transactionIsolation, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlProperty, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, connectable, tracking, mcp, enlistmentTrace, xaDataSourceProperty, xaDataSourceClass, driver, newConnectionSql, xaPool, recovery);
                    }
                    if (XaDataSource.Tag.forName(reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName(reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            this.parseConfigProperty(xaDataSourceProperty, reader);
                            break block12;
                        }
                        case XA_DATASOURCE_CLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block12;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block12;
                        }
                        case XA_POOL: {
                            xaPool = this.parseXaPool(reader);
                            break block12;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block12;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block12;
                        }
                        case URL_PROPERTY: {
                            urlProperty = this.elementAsString(reader);
                            break block12;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block12;
                        }
                        case TRANSACTION_ISOLATION: {
                            String str = this.elementAsString(reader);
                            transactionIsolation = TransactionIsolation.forName(str);
                            if (transactionIsolation != null) break block12;
                            transactionIsolation = TransactionIsolation.customLevel(str);
                            break block12;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block12;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block12;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block12;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block12;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DataSource parseDataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String connectionUrl = null;
        String driverClass = null;
        String dataSourceClass = null;
        String driver = null;
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsPool pool = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean jta = Defaults.JTA;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        String mcp = Defaults.MCP;
        Boolean enlistmentTrace = Defaults.ENLISTMENT_TRACE;
        block33: for (DataSource.Attribute attribute : DataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENABLED);
                    continue block33;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block33;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block33;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_JAVA_CONTEXT);
                    continue block33;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.SPY);
                    continue block33;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.USE_CCM);
                    continue block33;
                }
                case JTA: {
                    jta = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.JTA);
                    continue block33;
                }
                case CONNECTABLE: {
                    connectable = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.CONNECTABLE);
                    continue block33;
                }
                case TRACKING: {
                    tracking = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.TRACKING);
                    continue block33;
                }
                case MCP: {
                    mcp = this.attributeAsString(reader, attribute.getLocalName());
                    continue block33;
                }
                case ENLISTMENT_TRACE: {
                    enlistmentTrace = this.attributeAsBoolean(reader, attribute.getLocalName(), Defaults.ENLISTMENT_TRACE);
                    continue block33;
                }
            }
        }
        while (reader.hasNext()) {
            block13 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName(reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        return new DataSourceImpl(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta, connectable, tracking, mcp, enlistmentTrace, pool);
                    }
                    if (DataSource.Tag.forName(reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName(reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            this.parseConfigProperty(connectionProperties, reader);
                            break block13;
                        }
                        case CONNECTION_URL: {
                            connectionUrl = this.elementAsString(reader);
                            break block13;
                        }
                        case DRIVER_CLASS: {
                            driverClass = this.elementAsString(reader);
                            break block13;
                        }
                        case DATASOURCE_CLASS: {
                            dataSourceClass = this.elementAsString(reader);
                            break block13;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block13;
                        }
                        case POOL: {
                            pool = this.parsePool(reader);
                            break block13;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block13;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block13;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block13;
                        }
                        case TRANSACTION_ISOLATION: {
                            String str = this.elementAsString(reader);
                            transactionIsolation = TransactionIsolation.forName(str);
                            if (transactionIsolation != null) break block13;
                            transactionIsolation = TransactionIsolation.customLevel(str);
                            break block13;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block13;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block13;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block13;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block13;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

