/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class StatementImpl
implements Statement {
    private static final long serialVersionUID = 3361665706947342366L;
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);
    private final Boolean sharePreparedStatements;
    private final Long preparedStatementsCacheSize;
    private final Statement.TrackStatementsEnum trackStatements;

    public StatementImpl(Boolean sharePreparedStatements, Long preparedStatementsCacheSize, Statement.TrackStatementsEnum trackStatements) throws ValidateException {
        this.sharePreparedStatements = sharePreparedStatements;
        this.preparedStatementsCacheSize = preparedStatementsCacheSize;
        this.trackStatements = trackStatements;
        this.validate();
    }

    @Override
    public final Boolean isSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    @Override
    public final Long getPreparedStatementsCacheSize() {
        return this.preparedStatementsCacheSize;
    }

    @Override
    public final Statement.TrackStatementsEnum getTrackStatements() {
        return this.trackStatements;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.preparedStatementsCacheSize == null ? 0 : this.preparedStatementsCacheSize.hashCode());
        result = 31 * result + (this.sharePreparedStatements == null ? 0 : this.sharePreparedStatements.hashCode());
        result = 31 * result + (this.trackStatements == null ? 0 : this.trackStatements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementImpl)) {
            return false;
        }
        StatementImpl other = (StatementImpl)obj;
        if (this.preparedStatementsCacheSize == null ? other.preparedStatementsCacheSize != null : !this.preparedStatementsCacheSize.equals(other.preparedStatementsCacheSize)) {
            return false;
        }
        if (this.sharePreparedStatements == null ? other.sharePreparedStatements != null : !this.sharePreparedStatements.equals(other.sharePreparedStatements)) {
            return false;
        }
        return this.trackStatements == other.trackStatements;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<statement>");
        if (this.trackStatements != null) {
            sb.append("<").append((Object)Statement.Tag.TRACK_STATEMENTS).append(">");
            sb.append((Object)this.trackStatements);
            sb.append("</").append((Object)Statement.Tag.TRACK_STATEMENTS).append(">");
        }
        if (this.preparedStatementsCacheSize != null) {
            sb.append("<").append((Object)Statement.Tag.PREPARED_STATEMENT_CACHE_SIZE).append(">");
            sb.append(this.preparedStatementsCacheSize);
            sb.append("</").append((Object)Statement.Tag.PREPARED_STATEMENT_CACHE_SIZE).append(">");
        }
        if (this.sharePreparedStatements != null && Boolean.TRUE.equals(this.sharePreparedStatements)) {
            sb.append("<").append((Object)Statement.Tag.SHARE_PREPARED_STATEMENTS).append("/>");
        }
        sb.append("</statement>");
        return sb.toString();
    }

    @Override
    public void validate() throws ValidateException {
        if (this.preparedStatementsCacheSize != null && this.preparedStatementsCacheSize < 0L) {
            throw new ValidateException(bundle.invalidNegative(Statement.Tag.PREPARED_STATEMENT_CACHE_SIZE.getLocalName()));
        }
    }
}

