/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class ValidationImpl
implements Validation {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);
    protected Boolean validateOnMatch;
    protected Boolean backgroundValidation;
    protected Long backgroundValidationMillis;
    protected Boolean useFastFail;

    public ValidationImpl(Boolean validateOnMatch, Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail) throws ValidateException {
        this.validateOnMatch = validateOnMatch;
        this.backgroundValidation = backgroundValidation;
        this.backgroundValidationMillis = backgroundValidationMillis;
        this.useFastFail = useFastFail;
        this.partialCommonValidate();
    }

    @Override
    public Boolean isValidateOnMatch() {
        return this.validateOnMatch;
    }

    @Override
    public Boolean isBackgroundValidation() {
        return this.backgroundValidation;
    }

    @Override
    public Long getBackgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    @Override
    public Boolean isUseFastFail() {
        return this.useFastFail;
    }

    private void partialCommonValidate() throws ValidateException {
        if (this.backgroundValidationMillis != null && this.backgroundValidationMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(Validation.Tag.BACKGROUND_VALIDATION_MILLIS.getLocalName()));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.validateOnMatch == null ? 0 : this.validateOnMatch.hashCode());
        result = 31 * result + (this.backgroundValidation == null ? 0 : this.backgroundValidation.hashCode());
        result = 31 * result + (this.backgroundValidationMillis == null ? 0 : this.backgroundValidationMillis.hashCode());
        result = 31 * result + (this.useFastFail == null ? 0 : this.useFastFail.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationImpl)) {
            return false;
        }
        ValidationImpl other = (ValidationImpl)obj;
        if (this.validateOnMatch == null ? other.validateOnMatch != null : !this.validateOnMatch.equals(other.validateOnMatch)) {
            return false;
        }
        if (this.backgroundValidation == null ? other.backgroundValidation != null : !this.backgroundValidation.equals(other.backgroundValidation)) {
            return false;
        }
        if (this.backgroundValidationMillis == null ? other.backgroundValidationMillis != null : !this.backgroundValidationMillis.equals(other.backgroundValidationMillis)) {
            return false;
        }
        return !(this.useFastFail == null ? other.useFastFail != null : !this.useFastFail.equals(other.useFastFail));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<validation>");
        if (this.validateOnMatch != null) {
            sb.append("<").append((Object)Validation.Tag.VALIDATE_ON_MATCH).append(">");
            sb.append(this.validateOnMatch);
            sb.append("</").append((Object)Validation.Tag.VALIDATE_ON_MATCH).append(">");
        }
        if (this.backgroundValidation != null) {
            sb.append("<").append((Object)Validation.Tag.BACKGROUND_VALIDATION).append(">");
            sb.append(this.backgroundValidation);
            sb.append("</").append((Object)Validation.Tag.BACKGROUND_VALIDATION).append(">");
        }
        if (this.backgroundValidationMillis != null) {
            sb.append("<").append((Object)Validation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
            sb.append(this.backgroundValidationMillis);
            sb.append("</").append((Object)Validation.Tag.BACKGROUND_VALIDATION_MILLIS).append(">");
        }
        if (this.useFastFail != null) {
            sb.append("<").append((Object)Validation.Tag.USE_FAST_FAIL).append(">");
            sb.append(this.useFastFail);
            sb.append("</").append((Object)Validation.Tag.USE_FAST_FAIL).append(">");
        }
        sb.append("</validation>");
        return sb.toString();
    }
}

